/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.europeana.entity.client.exception.TechnicalRuntimeException;
import eu.europeana.entity.client.service.RestClient;
import eu.europeana.entity.client.utils.EntityClientUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.reactive.function.client.WebClient;

public class EntityApiRestClient
extends RestClient {
    private static final Logger LOGGER = LogManager.getLogger(EntityApiRestClient.class);
    private final WebClient webClient;
    private final String wskey;

    public EntityApiRestClient(WebClient webClient, String wskey) {
        this.webClient = webClient;
        this.wskey = wskey;
    }

    public List<String> retrieveSuggestions(String text, String language, String scope, String type, String rows, String algorithm) throws JsonProcessingException, TechnicalRuntimeException {
        String results = (String)this.getEntityId(this.webClient, EntityClientUtils.buildSuggestUrl(text, language, scope, type, rows, algorithm, this.wskey), false);
        List<String> entities = EntityClientUtils.getEntityApiResults(results);
        if (entities.isEmpty()) {
            LOGGER.debug("No entity found for suggest text={}, lang={}, type={}", (Object)text, (Object)language, (Object)type);
        }
        LOGGER.debug("{} entities found for suggest text={}, lang={}, type={}", (Object)entities.size(), (Object)text, (Object)language, (Object)type);
        return entities;
    }

    public List<String> retrieveEntityByUri(String uri) throws TechnicalRuntimeException {
        String entityId = (String)this.getEntityId(this.webClient, EntityClientUtils.buildEntityResolveUrl(uri, this.wskey), true);
        if (StringUtils.isNotEmpty((CharSequence)entityId)) {
            LOGGER.debug("{} entity found for uri={} ", (Object)entityId, (Object)uri);
            return Collections.singletonList("\"" + entityId + "\"");
        }
        LOGGER.debug("No entity found for resolve uri={}", (Object)uri);
        return Collections.emptyList();
    }

    public List<String> retrieveEnrichment(String text, String language, String type, String rows) throws JsonProcessingException, TechnicalRuntimeException {
        String results = (String)this.getEntityId(this.webClient, EntityClientUtils.buildEntityEnrichUrl(text, language, type, rows, this.wskey), false);
        List<String> entities = EntityClientUtils.getEntityApiResults(results);
        if (entities.isEmpty()) {
            LOGGER.debug("No entity found for enrich text={}, lang={}, type={}", (Object)text, (Object)language, (Object)type);
        }
        LOGGER.debug("{} entities found for enrich text={}, lang={}, type={}", (Object)entities.size(), (Object)text, (Object)language, (Object)type);
        return entities;
    }
}

