/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client;

import eu.europeana.entity.client.config.EntityClientConfiguration;
import eu.europeana.entity.client.service.EntityApiRestClient;
import eu.europeana.entity.client.service.EntityManagementRestClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

public class BaseEntityApiClient {
    private static final Logger LOG = LogManager.getLogger(BaseEntityApiClient.class);
    private static final int maxInMemSizeMb = 10;
    private final EntityClientConfiguration configuration;
    private EntityApiRestClient entityApiRestClient;
    private EntityManagementRestClient entityManagementRestClient;

    protected BaseEntityApiClient(EntityClientConfiguration configuration) {
        this.configuration = configuration;
        this.entityApiRestClient = new EntityApiRestClient(this.getApiClient(this.configuration.getEntityApiUrl()), this.configuration.getApikey());
        this.entityManagementRestClient = new EntityManagementRestClient(this.getApiClient(this.configuration.getEntityManagementUrl()), this.configuration.getApikey());
    }

    protected BaseEntityApiClient() {
        this(new EntityClientConfiguration());
    }

    private WebClient getApiClient(String apiEndpoint) {
        return WebClient.builder().baseUrl(apiEndpoint).filter(this.logRequest()).exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0xA00000)).build()).build();
    }

    private ExchangeFilterFunction logRequest() {
        return (clientRequest, next) -> {
            LOG.debug("Request: {} {}", (Object)clientRequest.method(), (Object)clientRequest.url());
            return next.exchange(clientRequest);
        };
    }

    public EntityClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public EntityApiRestClient getEntityApiRestClient() {
        return this.entityApiRestClient;
    }

    public EntityManagementRestClient getEntityManagementRestClient() {
        return this.entityManagementRestClient;
    }
}

