/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.oauth2.utils;

import eu.europeana.api.commons.exception.ApiKeyExtractionException;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaApiCredentials;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaAuthenticationToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;

public class OAuthUtils {
    public static final String HEADER_XAPIKEY = "X-Api-Key";
    public static final String TYPE_APIKEY = "APIKEY";
    public static final String TYPE_BEARER = "Bearer";
    public static final String AZP = "azp";
    public static final String EXP = "exp";
    public static final String AUD = "aud";
    public static final String SCOPE = "scope";
    public static final String RESOURCE_ACCESS = "resource_access";
    public static final String ROLES = "roles";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String USER_ID = "sub";
    static JsonParser objectMapper = JsonParserFactory.create();

    public static String extractApiKey(HttpServletRequest request) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String wskeyParam = request.getParameter("wskey");
        if (wskeyParam != null) {
            return wskeyParam;
        }
        String xApiKeyHeader = request.getHeader(HEADER_XAPIKEY);
        if (xApiKeyHeader != null) {
            return xApiKeyHeader;
        }
        String apikey = OAuthUtils.extractPayloadFromAuthorizationHeader(request, TYPE_APIKEY);
        if (apikey == null) {
            throw new ApiKeyExtractionException("No APIKey provided within the request or authorization header!");
        }
        return apikey;
    }

    public static List<? extends Authentication> processJwtToken(HttpServletRequest request, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String authorization = request.getHeader("Authorization");
        return OAuthUtils.extractAuthenticationList(authorization, signatureVerifier, api);
    }

    public static List<? extends Authentication> extractAuthenticationList(String authorization, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        ArrayList<Authentication> authenticationList = new ArrayList<Authentication>();
        String encodedToken = OAuthUtils.extractPayloadFromHeaderValue(TYPE_BEARER, authorization);
        if (encodedToken == null) {
            return null;
        }
        try {
            Map<String, Object> data = OAuthUtils.extractCustomData(encodedToken, signatureVerifier, api);
            OAuthUtils.processResourceAccessClaims(api, data, authenticationList);
        }
        catch (RuntimeException e) {
            throw new AuthorizationExtractionException("Unexpected exception occured when processing JWT Token for authorization", e);
        }
        return authenticationList;
    }

    public static void processResourceAccessClaims(String api, Map<String, Object> data, List<Authentication> authenticationList) throws ApiKeyExtractionException {
        if (!OAuthUtils.verifyScope(api, data)) {
            return;
        }
        if (!OAuthUtils.verifyAudience(api, data)) {
            return;
        }
        if (!data.containsKey(RESOURCE_ACCESS)) {
            return;
        }
        Map resourceAccessMap = (Map)data.get(RESOURCE_ACCESS);
        String principal = (String)data.get(USER_ID);
        String userName = (String)data.get(PREFERRED_USERNAME);
        for (Map.Entry entry : resourceAccessMap.entrySet()) {
            String details = (String)entry.getKey();
            if (!api.equals(details)) continue;
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            Map rolesMap = (Map)entry.getValue();
            List roles = (List)rolesMap.get(ROLES);
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
            EuropeanaAuthenticationToken authenticationToken = new EuropeanaAuthenticationToken(authorities, details, principal, new EuropeanaApiCredentials(userName));
            authenticationList.add((Authentication)authenticationToken);
        }
    }

    private static String extractPayloadFromAuthorizationHeader(HttpServletRequest request, String authorizationType) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String authorization = request.getHeader("Authorization");
        return OAuthUtils.extractPayloadFromHeaderValue(authorizationType, authorization);
    }

    private static String extractPayloadFromHeaderValue(String authorizationType, String authorization) throws AuthorizationExtractionException, ApiKeyExtractionException {
        if (authorization == null) {
            throw new AuthorizationExtractionException("No authentication information provided, Authorization header not submitted with the request! ");
        }
        if (!authorization.startsWith(TYPE_BEARER) && !authorization.startsWith(TYPE_APIKEY)) {
            throw new ApiKeyExtractionException("Unsupported type in Auhtorization header: " + authorization);
        }
        if (authorization.startsWith(authorizationType)) {
            return authorization.substring(authorizationType.length()).trim();
        }
        return null;
    }

    public static Map<String, Object> extractCustomData(HttpServletRequest request, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String encodedToken = OAuthUtils.extractPayloadFromAuthorizationHeader(request, TYPE_BEARER);
        if (encodedToken == null) {
            return null;
        }
        return OAuthUtils.extractCustomData(encodedToken, signatureVerifier, api);
    }

    public static String extractApiKeyFromJwtToken(HttpServletRequest request, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        Map<String, Object> data = OAuthUtils.extractCustomData(request, signatureVerifier, api);
        if (data == null) {
            return null;
        }
        return OAuthUtils.extractApiKey(data);
    }

    private static Map<String, Object> extractCustomData(String encodedToken, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        Map data = null;
        try {
            Jwt token = JwtHelper.decodeAndVerify((String)encodedToken, (SignatureVerifier)signatureVerifier);
            data = objectMapper.parseMap(token.getClaims());
            OAuthUtils.verifyTokenExpiration(data);
            OAuthUtils.verifySubject(data);
            OAuthUtils.verifyUserName(data);
        }
        catch (RuntimeException e) {
            throw new ApiKeyExtractionException("Unexpected exception occured when processing JWT Token", e);
        }
        return data;
    }

    public static String extractApiKey(Map<String, Object> data) throws ApiKeyExtractionException {
        String apikey = (String)data.get(AZP);
        if (apikey == null || StringUtils.isEmpty((CharSequence)apikey)) {
            throw new ApiKeyExtractionException("API KEY not available in provided JWT token");
        }
        return apikey;
    }

    private static boolean verifyAudience(String api, Map<String, Object> data) throws ApiKeyExtractionException {
        if (!data.containsKey(AUD)) {
            return false;
        }
        Object aud = data.get(AUD);
        if (aud instanceof String) {
            return aud.equals(api);
        }
        if (aud instanceof String[]) {
            Stream<String> values = Arrays.stream((String[])aud);
            return values.anyMatch(api::equals);
        }
        if (aud instanceof List) {
            return ((List)aud).contains(api);
        }
        throw new ApiKeyExtractionException("Invalid JWT token. Audience is not propertly formated. It must be a string or a string array: " + aud);
    }

    private static boolean verifyScope(String api, Map<String, Object> data) throws ApiKeyExtractionException {
        if (!data.containsKey(SCOPE)) {
            return false;
        }
        String scope = (String)data.get(SCOPE);
        String[] scopes = StringUtils.splitByWholeSeparator((String)scope, null);
        Stream<String> values = Arrays.stream(scopes);
        return values.anyMatch(api::equals);
    }

    private static void verifyTokenExpiration(Map<String, Object> data) throws ApiKeyExtractionException {
        int currentTime;
        int exp = (Integer)data.get(EXP);
        if (exp < (currentTime = (int)(System.currentTimeMillis() / 1000L))) {
            throw new ApiKeyExtractionException("Expired JWT token. Please refresh the token. Expiration time:  " + exp);
        }
    }

    private static void verifySubject(Map<String, Object> data) throws AuthorizationExtractionException {
        if (!data.containsKey(USER_ID)) {
            throw new AuthorizationExtractionException("User id not available in provided JWT token");
        }
    }

    private static void verifyUserName(Map<String, Object> data) throws AuthorizationExtractionException {
        if (!data.containsKey(PREFERRED_USERNAME)) {
            throw new AuthorizationExtractionException("Preffered User Name not available in provided JWT token");
        }
    }
}

