/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.oauth2.utils;

import eu.europeana.api.commons.exception.ApiKeyExtractionException;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaApiCredentials;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaAuthenticationToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;

public class OAuthUtils {
    public static final String HEADER_XAPIKEY = "X-Api-Key";
    public static final String TYPE_APIKEY = "APIKEY";
    public static final String TYPE_BEARER = "Bearer";
    public static final String AZP = "azp";
    public static final String EXP = "exp";
    public static final String AUD = "aud";
    public static final String SCOPE = "scope";
    public static final String RESOURCE_ACCESS = "resource_access";
    public static final String ROLES = "roles";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String USER_ID = "sub";
    public static final String CLIENT_ID = "client_public_id";
    static JsonParser objectMapper = JsonParserFactory.create();

    public static String extractApiKey(HttpServletRequest request) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String wskeyParam = request.getParameter("wskey");
        if (wskeyParam != null) {
            return wskeyParam;
        }
        String xApiKeyHeader = request.getHeader(HEADER_XAPIKEY);
        if (xApiKeyHeader != null) {
            return xApiKeyHeader;
        }
        String apikey = OAuthUtils.extractPayloadFromAuthorizationHeader(request, TYPE_APIKEY);
        if (apikey == null) {
            throw new ApiKeyExtractionException("No APIKey provided within the request or authorization header!");
        }
        return apikey;
    }

    public static List<? extends Authentication> processJwtToken(HttpServletRequest request, RsaVerifier signatureVerifier, String api, boolean verifyResourceAcess) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String authorization = request.getHeader("Authorization");
        return OAuthUtils.extractAuthenticationList(authorization, signatureVerifier, api, verifyResourceAcess);
    }

    public static List<? extends Authentication> processJwtToken(HttpServletRequest request, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        return OAuthUtils.processJwtToken(request, signatureVerifier, api, true);
    }

    @Deprecated
    public static List<? extends Authentication> extractAuthenticationList(String authorization, RsaVerifier signatureVerifier, String api, boolean verifyResourceAccess) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String encodedToken = OAuthUtils.extractPayloadFromHeaderValue(TYPE_BEARER, authorization);
        if (encodedToken == null) {
            return null;
        }
        ArrayList<Authentication> authenticationList = new ArrayList<Authentication>();
        try {
            Map<String, Object> data = OAuthUtils.extractCustomData(encodedToken, signatureVerifier, api);
            OAuthUtils.processResourceAccessClaims(api, data, authenticationList, verifyResourceAccess);
        }
        catch (RuntimeException e) {
            throw new AuthorizationExtractionException("Unexpected exception occured when processing JWT Token for authorization", e);
        }
        return authenticationList;
    }

    public static List<? extends Authentication> extractAuthenticationList(String authorization, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        return OAuthUtils.extractAuthenticationList(authorization, signatureVerifier, api, true);
    }

    public static void processResourceAccessClaims(String api, Map<String, Object> data, List<Authentication> authenticationList) throws ApiKeyExtractionException {
        OAuthUtils.processResourceAccessClaims(api, data, authenticationList, true);
    }

    public static void processResourceAccessClaims(String api, Map<String, Object> data, List<Authentication> authenticationList, boolean verifyResouceAccess) throws ApiKeyExtractionException {
        if (!OAuthUtils.verifyScope(api, data)) {
            return;
        }
        if (verifyResouceAccess && !OAuthUtils.verifyAudience(api, data)) {
            return;
        }
        if (!data.containsKey(USER_ID)) {
            throw new ApiKeyExtractionException("Invalid JWT token. mandatory field missing: sub");
        }
        String clientId = data.getOrDefault(CLIENT_ID, null);
        String userName = (String)data.getOrDefault(PREFERRED_USERNAME, "annonymous");
        String apiKey = OAuthUtils.extractApiKey(data);
        String principal = (String)data.get(USER_ID);
        EuropeanaApiCredentials apiCredentials = new EuropeanaApiCredentials(userName, clientId, apiKey);
        if (verifyResouceAccess) {
            if (data.containsKey(RESOURCE_ACCESS)) {
                Map resourceAccessMap = (Map)data.get(RESOURCE_ACCESS);
                OAuthUtils.processResourceAccessMap(api, authenticationList, resourceAccessMap, principal, apiCredentials);
            }
        } else {
            List<SimpleGrantedAuthority> authorities = List.of(new SimpleGrantedAuthority("user"));
            EuropeanaAuthenticationToken authenticationToken = new EuropeanaAuthenticationToken(authorities, api, principal, apiCredentials);
            authenticationList.add((Authentication)authenticationToken);
        }
    }

    private static void processResourceAccessMap(String api, List<Authentication> authenticationList, Map<String, Object> resourceAccessMap, String principal, EuropeanaApiCredentials credentials) {
        for (Map.Entry<String, Object> entry : resourceAccessMap.entrySet()) {
            String details = entry.getKey();
            if (!api.equals(details)) continue;
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            Map rolesMap = (Map)entry.getValue();
            List roles = (List)rolesMap.get(ROLES);
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
            EuropeanaAuthenticationToken authenticationToken = new EuropeanaAuthenticationToken(authorities, api, principal, credentials);
            authenticationList.add((Authentication)authenticationToken);
        }
    }

    private static String extractPayloadFromAuthorizationHeader(HttpServletRequest request, String authorizationType) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String authorization = request.getHeader("Authorization");
        return OAuthUtils.extractPayloadFromHeaderValue(authorizationType, authorization);
    }

    private static String extractPayloadFromHeaderValue(String authorizationType, String authorization) throws AuthorizationExtractionException, ApiKeyExtractionException {
        if (authorization == null) {
            throw new AuthorizationExtractionException("No authentication information provided, Authorization header not submitted with the request! ");
        }
        if (!authorization.startsWith(TYPE_BEARER) && !authorization.startsWith(TYPE_APIKEY)) {
            throw new ApiKeyExtractionException("Unsupported type in Auhtorization header: " + authorization);
        }
        if (authorization.startsWith(authorizationType)) {
            return authorization.substring(authorizationType.length()).trim();
        }
        return null;
    }

    public static Map<String, Object> extractCustomData(HttpServletRequest request, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        String encodedToken = OAuthUtils.extractPayloadFromAuthorizationHeader(request, TYPE_BEARER);
        if (encodedToken == null) {
            return null;
        }
        return OAuthUtils.extractCustomData(encodedToken, signatureVerifier, api);
    }

    static String extractApiKeyFromJwtToken(HttpServletRequest request, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        Map<String, Object> data = OAuthUtils.extractCustomData(request, signatureVerifier, api);
        if (data == null) {
            return null;
        }
        return OAuthUtils.extractApiKey(data);
    }

    private static Map<String, Object> extractCustomData(String encodedToken, RsaVerifier signatureVerifier, String api) throws ApiKeyExtractionException, AuthorizationExtractionException {
        Map data = null;
        try {
            Jwt token = JwtHelper.decodeAndVerify((String)encodedToken, (SignatureVerifier)signatureVerifier);
            data = objectMapper.parseMap(token.getClaims());
            OAuthUtils.verifyTokenExpiration(data);
            OAuthUtils.verifySubject(data);
            OAuthUtils.verifyUserName(data);
        }
        catch (RuntimeException e) {
            throw new ApiKeyExtractionException("Unexpected exception occured when processing JWT Token", e);
        }
        return data;
    }

    public static String extractApiKey(Map<String, Object> data) throws ApiKeyExtractionException {
        String apikey = (String)data.get(AZP);
        if (apikey == null || StringUtils.isEmpty((CharSequence)apikey)) {
            throw new ApiKeyExtractionException("API KEY not available in provided JWT token");
        }
        return apikey;
    }

    private static boolean verifyAudience(String api, Map<String, Object> data) throws ApiKeyExtractionException {
        if (!data.containsKey(AUD)) {
            return false;
        }
        Object aud = data.get(AUD);
        if (aud instanceof String) {
            return aud.equals(api);
        }
        if (aud instanceof String[]) {
            Stream<String> values = Arrays.stream((String[])aud);
            return values.anyMatch(api::equals);
        }
        if (aud instanceof List) {
            return ((List)aud).contains(api);
        }
        throw new ApiKeyExtractionException("Invalid JWT token. Audience is not propertly formated. It must be a string or a string array: " + aud);
    }

    private static boolean verifyScope(String api, Map<String, Object> data) {
        if (!data.containsKey(SCOPE)) {
            return false;
        }
        String scope = (String)data.get(SCOPE);
        String[] scopes = StringUtils.splitByWholeSeparator((String)scope, null);
        Stream<String> values = Arrays.stream(scopes);
        return values.anyMatch(api::equals);
    }

    private static void verifyTokenExpiration(Map<String, Object> data) throws ApiKeyExtractionException {
        int currentTime;
        int exp = (Integer)data.get(EXP);
        if (exp < (currentTime = (int)(System.currentTimeMillis() / 1000L))) {
            throw new ApiKeyExtractionException("Expired JWT token. Please refresh the token. Expiration time:  " + exp);
        }
    }

    private static void verifySubject(Map<String, Object> data) throws AuthorizationExtractionException {
        if (!data.containsKey(USER_ID)) {
            throw new AuthorizationExtractionException("User id not available in provided JWT token");
        }
    }

    private static void verifyUserName(Map<String, Object> data) throws AuthorizationExtractionException {
        if (!data.containsKey(PREFERRED_USERNAME)) {
            throw new AuthorizationExtractionException("Preffered User Name not available in provided JWT token");
        }
    }

    public static Authentication buildReadOnlyAuthenticationToken(String apiName, Map<String, Object> data, String apiKey) throws ApiKeyExtractionException {
        String userName = (String)data.get(PREFERRED_USERNAME);
        if (userName == null) {
            userName = "annonymous";
        }
        String principal = (String)data.get(USER_ID);
        String clientId = (String)data.getOrDefault(CLIENT_ID, "unknown");
        EuropeanaAuthenticationToken authentication = new EuropeanaAuthenticationToken(null, apiName, principal, new EuropeanaApiCredentials(userName, clientId, apiKey));
        return authentication;
    }

    public static EuropeanaAuthenticationToken buildReadOnlyAuthenticationToken(String apiName, String wsKey) {
        return new EuropeanaAuthenticationToken(null, apiName, "annonymous", new EuropeanaApiCredentials("annonymous", "unknown", wsKey));
    }
}

