/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.oauth2;

import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.approval.ApprovalStoreUserApprovalHandler;

public class ApiApprovalHandler
extends ApprovalStoreUserApprovalHandler {
    private boolean useApprovalStore = true;
    private ClientDetailsService clientDetailsService;

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
        super.setClientDetailsService(clientDetailsService);
    }

    public void setUseApprovalStore(boolean useApprovalStore) {
        this.useApprovalStore = useApprovalStore;
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean approved = false;
        if (this.useApprovalStore) {
            authorizationRequest = super.checkForPreApproval(authorizationRequest, userAuthentication);
            approved = authorizationRequest.isApproved();
        } else if (this.clientDetailsService != null) {
            Set requestedScopes = authorizationRequest.getScope();
            try {
                ClientDetails client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId());
                for (String scope : requestedScopes) {
                    if (!client.isAutoApprove(scope)) continue;
                    approved = true;
                    break;
                }
            }
            catch (ClientRegistrationException clientRegistrationException) {
                // empty catch block
            }
        }
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }
}

