/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.oauth2.service.impl;

import eu.europeana.api.commons.oauth2.model.impl.ClientDetailsAdapter;
import eu.europeana.apikey.client.ApiKeyValidationResult;
import eu.europeana.apikey.client.Client;
import eu.europeana.apikey.client.exception.ApiKeyValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.stereotype.Service;

@Service(value="commons_oauth2_europeanaClientDetailsService")
public class EuropeanaClientDetailsService
implements ClientDetailsService {
    private String apiKeyServiceUrl;
    private Client apiKeyClient;

    public Client getApiKeyClient() {
        if (this.apiKeyClient == null) {
            this.apiKeyClient = new Client(this.getApiKeyServiceUrl());
        }
        return this.apiKeyClient;
    }

    public ClientDetails loadClientByClientId(String key) throws OAuth2Exception, ClientRegistrationException {
        ApiKeyValidationResult validation;
        if (StringUtils.isBlank((CharSequence)this.getApiKeyServiceUrl())) {
            return null;
        }
        try {
            validation = this.getApiKeyClient().validateApiKey(key);
        }
        catch (ApiKeyValidationException | RuntimeException e) {
            throw new OAuth2Exception("Invocation of api key service failed. Cannot validate ApiKey : " + key, e);
        }
        if (validation != null && validation.isValidApiKey()) {
            return new ClientDetailsAdapter(key);
        }
        if (validation == null || 500 == validation.getHttpStatus()) {
            String message = validation == null ? "unknown" : validation.getErrorMessage();
            throw new OAuth2Exception("Invocation of api key service failed. Cannot validate ApiKey : " + key + ". Reason:" + message);
        }
        throw new ClientRegistrationException("Invalid API key: " + key + " Reason: " + validation.getHttpStatus() + " : " + validation.getErrorMessage());
    }

    public String getApiKeyServiceUrl() {
        return this.apiKeyServiceUrl;
    }

    public void setApiKeyServiceUrl(String apiKeyServiceUrl) {
        this.apiKeyServiceUrl = apiKeyServiceUrl;
    }
}

