/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.oauth2.service.impl;

import eu.europeana.api.commons.exception.CommonServiceException;
import eu.europeana.api.commons.exception.CommonServiceRuntimeException;
import eu.europeana.api.commons.oauth2.service.OAuth2TokenService;
import eu.europeana.api.commons.oauth2.service.impl.BridgeAuthenticationKeyGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;
import org.springframework.stereotype.Service;

@Service
public class BridgeApiTokenStoreService
extends InMemoryTokenStore
implements TokenStore,
OAuth2TokenService {
    public BridgeApiTokenStoreService() {
        this.setAuthenticationKeyGenerator(new BridgeAuthenticationKeyGenerator());
        this.initService();
    }

    private void initService() {
    }

    @Override
    public OAuth2RefreshToken findAccessToken(String token) throws CommonServiceException, CommonServiceRuntimeException {
        OAuth2AccessToken accessToken = this.readAccessToken(token);
        return this.convertToRefreshTocken(accessToken);
    }

    protected OAuth2RefreshToken convertToRefreshTocken(OAuth2AccessToken accessToken) {
        return new DefaultOAuth2RefreshToken(accessToken.getValue());
    }

    @Override
    public List<OAuth2RefreshToken> findByClientIdAndUserName(String clientId, String userName) throws CommonServiceException, CommonServiceRuntimeException {
        Collection accessTokens = this.findTokensByClientIdAndUserName(clientId, userName);
        return this.convertToRefreshToken(accessTokens);
    }

    @Override
    public List<OAuth2RefreshToken> findByClientId(String clientId) throws CommonServiceException, CommonServiceRuntimeException {
        return this.convertToRefreshToken(this.findTokensByClientId(clientId));
    }

    protected List<OAuth2RefreshToken> convertToRefreshToken(Collection<OAuth2AccessToken> accessTokens) {
        ArrayList<OAuth2RefreshToken> refreshTokens = new ArrayList<OAuth2RefreshToken>(accessTokens.size());
        for (OAuth2AccessToken accessToken : accessTokens) {
            refreshTokens.add(this.convertToRefreshTocken(accessToken));
        }
        return refreshTokens;
    }
}

