/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.db.wrapper;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MapperOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiMongoConnector {
    private static final Logger log = LogManager.getLogger(ApiMongoConnector.class);
    SSLContext sslContext = null;
    MongoClient mongoClient = null;
    int DEFAULT_IDLE_TIME = 5000;

    public Datastore createDatastore(String connectionUri, String truststore, String truststorePass) {
        return this.createDatastore(connectionUri, truststore, truststorePass, this.DEFAULT_IDLE_TIME);
    }

    public Datastore createDatastore(String connectionUri, String truststore, String truststorePass, int maxConnectionIdleTime) {
        return this.createDatastore(connectionUri, truststore, truststorePass, maxConnectionIdleTime, null);
    }

    public Datastore createDatastore(String connectionUri, String truststore, String truststorePass, int maxConnectionIdleTime, String ... mongoModelPackage) {
        Datastore datastore = null;
        log.debug("Connecting to mongo server:" + connectionUri);
        MongoClientOptions.Builder mco = this.buildMongoConnectionOptions(connectionUri, truststore, truststorePass);
        if (maxConnectionIdleTime > 0) {
            mco.maxConnectionIdleTime(maxConnectionIdleTime);
        } else {
            mco.maxConnectionIdleTime(this.DEFAULT_IDLE_TIME);
        }
        MongoClientURI mongoUri = new MongoClientURI(connectionUri, mco);
        this.mongoClient = new MongoClient(mongoUri);
        if (mongoModelPackage != null && mongoModelPackage.length > 0) {
            datastore = this.createConnectionAndIndices(mongoUri, mongoModelPackage);
        } else {
            Morphia connection = new Morphia();
            datastore = connection.createDatastore(this.mongoClient, mongoUri.getDatabase());
        }
        log.info(String.format("Connection to db '%s' mongo server was successful", mongoUri.getDatabase()));
        return datastore;
    }

    protected Datastore createConnectionAndIndices(MongoClientURI mongoUri, String ... mongoModelPackage) {
        MapperOptions options = new MapperOptions();
        options.setMapSubPackages(true);
        Mapper packageMapper = new Mapper(options);
        Morphia connection = new Morphia(packageMapper);
        for (String modelPackage : mongoModelPackage) {
            connection.mapPackage(modelPackage, false);
        }
        Datastore datastore = connection.createDatastore(this.mongoClient, mongoUri.getDatabase());
        datastore.ensureIndexes();
        return datastore;
    }

    protected MongoClientOptions.Builder buildMongoConnectionOptions(String connectionUri, String truststore, String truststorePass) {
        MongoClientOptions.Builder mco = MongoClientOptions.builder();
        if (this.isSslEnabled(connectionUri)) {
            mco.sslEnabled(true).sslInvalidHostNameAllowed(true);
            if (!StringUtils.isEmpty((CharSequence)truststore)) {
                this.validateTrustStoreConfig(truststore, truststorePass);
                log.debug("Enabling ssl connection using truststore: " + truststore + ":" + truststorePass);
                SSLContext sc = this.getSslContext(truststore, truststorePass);
                mco.sslContext(sc);
            }
        }
        mco.readPreference(this.defaultReadPreference());
        mco.writeConcern(this.defaultWriteConcern());
        mco.readConcern(this.defultReadConcern());
        return mco;
    }

    private ReadConcern defultReadConcern() {
        return ReadConcern.MAJORITY;
    }

    protected WriteConcern defaultWriteConcern() {
        return WriteConcern.MAJORITY;
    }

    protected ReadPreference defaultReadPreference() {
        return ReadPreference.primaryPreferred();
    }

    public SSLContext getSslContext(String truststore, String truststorePass) {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        if (truststore.startsWith("/")) {
            return this.loadTrustStoreFromFile(truststore, truststorePass);
        }
        return this.loadTrustStoreFromClasspath(truststore, truststorePass);
    }

    public void close() {
        if (this.mongoClient != null) {
            try {
                log.info("Shutting down connections to Mongo...");
                this.mongoClient.close();
            }
            catch (Throwable th) {
                log.error("cannot close mongo connetions", th);
            }
        }
    }

    protected void validateTrustStoreConfig(String truststore, String truststorePass) {
        if (StringUtils.isEmpty((CharSequence)truststore) || StringUtils.isEmpty((CharSequence)truststorePass)) {
            throw new IllegalArgumentException("Both trustore and truststorePass must be provided, when trustore is used! " + truststore + ":" + truststorePass);
        }
    }

    private boolean isSslEnabled(String connectionUri) {
        return connectionUri.contains("tls=true") || connectionUri.contains("ssl=true");
    }

    private SSLContext loadTrustStoreFromClasspath(String truststore, String truststorePass) {
        SSLContext sSLContext;
        block10: {
            log.debug("Loading trustore from classpath: {}", (Object)truststore);
            String trustStoreLocation = "/" + truststore;
            URL trustStoreUri = this.getClass().getResource(trustStoreLocation);
            if (trustStoreUri == null) {
                log.info("truststore not at location: {}, search in config subfolder.", (Object)trustStoreLocation);
                trustStoreLocation = "/config/" + truststore;
                trustStoreUri = this.getClass().getResource(trustStoreLocation);
                if (trustStoreUri == null) {
                    log.info("truststore not at location: {}, search in config subfolder.", (Object)trustStoreLocation);
                    throw new MongoClientException("cannot find trustore file in classpath: " + trustStoreLocation);
                }
            }
            InputStream stream = this.getClass().getResourceAsStream(trustStoreLocation);
            try {
                sSLContext = this.loadCertificateToSslContext(stream, truststorePass);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                    throw new MongoClientException("Cannot initialize mongo truststore", (Throwable)ex);
                }
            }
            stream.close();
        }
        return sSLContext;
    }

    private SSLContext loadTrustStoreFromFile(String truststore, String truststorePass) {
        SSLContext sSLContext;
        File trustoreFile = new File(truststore);
        if (!trustoreFile.exists()) {
            throw new MongoClientException("Trustore file location does not exist: " + truststore);
        }
        log.debug("Loading truststore from file {}", (Object)trustoreFile);
        FileInputStream stream = new FileInputStream(trustoreFile);
        try {
            sSLContext = this.loadCertificateToSslContext(stream, truststorePass);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new MongoClientException("Cannot initialize mongo truststore", (Throwable)ex);
            }
        }
        ((InputStream)stream).close();
        return sSLContext;
    }

    private SSLContext loadCertificateToSslContext(InputStream stream, String truststorePass) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException {
        KeyStore jks = KeyStore.getInstance("JKS");
        jks.load(stream, truststorePass.toCharArray());
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(jks);
        this.sslContext = SSLContext.getInstance("TLSv1.2");
        this.sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
        return this.sslContext;
    }
}

