/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.nosql.service.impl;

import dev.morphia.query.Query;
import eu.europeana.api.commons.definitions.exception.ApiWriteLockException;
import eu.europeana.api.commons.nosql.entity.ApiWriteLock;
import eu.europeana.api.commons.nosql.entity.ApiWriteLockImpl;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.nosql.service.impl.AbstractNoSqlServiceImpl;
import java.util.Date;
import org.bson.types.ObjectId;
import org.springframework.cache.annotation.EnableCaching;

@EnableCaching
public class ApiWriteLockServiceImpl
extends AbstractNoSqlServiceImpl<ApiWriteLock, String>
implements ApiWriteLockService {
    @Override
    public ApiWriteLock lock(String lockType) throws ApiWriteLockException {
        try {
            ApiWriteLockImpl writeLock = new ApiWriteLockImpl(lockType);
            return super.store(writeLock);
        }
        catch (Exception e) {
            throw new ApiWriteLockException("Unable to create api write lock.", (Throwable)e);
        }
    }

    @Override
    public ApiWriteLock getLastActiveLock(String lockType) throws ApiWriteLockException {
        try {
            Query query = this.getDao().createQuery();
            if (lockType != null) {
                query.criteria("name").contains(lockType);
            }
            query.criteria("ended").doesNotExist();
            query.order("-started");
            return (ApiWriteLock)this.getDao().findOne(query);
        }
        catch (Exception e) {
            throw new ApiWriteLockException("Unable to get last api write lock.", (Throwable)e);
        }
    }

    @Override
    public ApiWriteLock getLockById(String id) throws ApiWriteLockException {
        try {
            Query query = this.getDao().createQuery();
            query.criteria("_id").equal((Object)new ObjectId(id));
            return (ApiWriteLock)this.getDao().findOne(query);
        }
        catch (Exception e) {
            throw new ApiWriteLockException("Unable to get api write lock by id.", (Throwable)e);
        }
    }

    @Override
    public void unlock(ApiWriteLock writeLock) throws ApiWriteLockException {
        try {
            writeLock.setEnded(new Date());
            super.store(writeLock);
        }
        catch (Exception e) {
            throw new ApiWriteLockException("Unable to unlock write operations for the api.", (Throwable)e);
        }
    }

    @Override
    public void deleteAllLocks() throws ApiWriteLockException {
        try {
            this.getDao().deleteAll();
        }
        catch (Exception e) {
            throw new ApiWriteLockException("Unable to delete api write locks.", (Throwable)e);
        }
    }
}

