/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.nosql.embedded;

import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmbeddedMongoServer {
    private static Logger LOG = LogManager.getLogger(EmbeddedMongoServer.class);
    public static final int DEFAULT_MONGO_PORT = 10001;
    MongodStarter starter;
    MongodExecutable mongodExecutable;

    public EmbeddedMongoServer() {
        this(10001);
    }

    public EmbeddedMongoServer(int port) {
        try {
            Version version = Version.V3_5_5;
            IMongodConfig conf = new MongodConfigBuilder().version((IFeatureAwareVersion)version).net(new Net(port, Network.localhostIsIPv6())).build();
            System.out.println(version);
            this.starter = MongodStarter.getDefaultInstance();
            this.mongodExecutable = (MongodExecutable)this.starter.prepare((IExecutableProcessConfig)conf);
        }
        catch (IOException e) {
            LOG.error("cannot start embedded mongo server", (Throwable)e);
        }
    }

    public void start() throws IOException {
        this.mongodExecutable.start();
    }

    public void stop() throws IOException {
        this.mongodExecutable.stop();
    }
}

