/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons.nosql.service.impl;

import dev.morphia.Key;
import dev.morphia.query.QueryResults;
import eu.europeana.api.commons.nosql.dao.NosqlDao;
import eu.europeana.api.commons.nosql.entity.NoSqlEntity;
import eu.europeana.api.commons.nosql.service.AbstractNoSqlService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractNoSqlServiceImpl<E extends NoSqlEntity, T extends Serializable>
implements AbstractNoSqlService<E, T> {
    private NosqlDao<E, T> dao;

    @Override
    public void remove(T id) {
        this.dao.deleteById(id);
    }

    @Override
    public E findByID(T id) {
        return (E)((NoSqlEntity)this.dao.get(id));
    }

    @Override
    public Iterable<E> findAll() {
        return this.dao.find().asList();
    }

    @Override
    public E store(E object) {
        Key key = this.dao.save(object);
        return (E)((NoSqlEntity)this.dao.get((Serializable)key.getId()));
    }

    @Override
    public boolean exists(T id) {
        return this.dao.exists("_id", id);
    }

    @Override
    public long count() {
        return this.dao.count();
    }

    public final void setDao(NosqlDao<E, T> dao) {
        this.dao = dao;
    }

    protected NosqlDao<E, T> getDao() {
        return this.dao;
    }

    @Override
    public List asList(QueryResults queryResults) {
        ArrayList result = new ArrayList();
        Iterator iter = queryResults.iterator();
        iter.forEachRemaining(result::add);
        return result;
    }
}

