/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.db.wrapper;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

public class ApiMongoConnector {
    private static final Logger log = LogManager.getLogger(ApiMongoConnector.class);
    SSLContext sslContext = null;
    MongoClient mongoClient = null;

    public Datastore createDatastore(String connectionUri, String truststore, String truststorePass) {
        Datastore datastore = null;
        Morphia connection = new Morphia();
        log.debug("Connecting to mongo server:" + connectionUri);
        MongoClientOptions.Builder mco = this.buildMongoConnectionOptions(connectionUri, truststore, truststorePass);
        MongoClientURI mongoUri = new MongoClientURI(connectionUri, mco);
        this.mongoClient = new MongoClient(mongoUri);
        datastore = connection.createDatastore(this.mongoClient, mongoUri.getDatabase());
        log.info(String.format("Connection to db '%s' mongo server was successful", mongoUri.getDatabase()));
        return datastore;
    }

    private MongoClientOptions.Builder buildMongoConnectionOptions(String connectionUri, String truststore, String truststorePass) {
        MongoClientOptions.Builder mco = MongoClientOptions.builder();
        if (this.isSslEnabled(connectionUri)) {
            mco.sslEnabled(true).sslInvalidHostNameAllowed(true);
            if (!StringUtils.isEmpty((CharSequence)truststore)) {
                this.validateTrustStoreConfig(truststore, truststorePass);
                log.debug("Enabling ssl connection using truststore: " + truststore + ":" + truststorePass);
                SSLContext sc = this.getSslContext(truststore, truststorePass);
                mco.socketFactory((SocketFactory)sc.getSocketFactory());
            }
        }
        return mco;
    }

    public void close() {
        if (this.mongoClient != null) {
            try {
                log.info("Shutting down connections to Mongo...");
                this.mongoClient.close();
            }
            catch (Throwable th) {
                log.error("cannot close mongo connetions", th);
            }
        }
    }

    protected void validateTrustStoreConfig(String truststore, String truststorePass) {
        if (StringUtils.isEmpty((CharSequence)truststore) || StringUtils.isEmpty((CharSequence)truststorePass)) {
            throw new IllegalArgumentException("Both trustore and truststorePass must be provided, when trustore is used! " + truststore + ":" + truststorePass);
        }
    }

    private boolean isSslEnabled(String connectionUri) {
        return connectionUri.contains("ssl=true");
    }

    private SSLContext initSSLContext(String truststore, String truststorePass) {
        try {
            String trustStoreLocation = "/config/" + truststore;
            URL trustStoreUri = this.getClass().getResource(trustStoreLocation);
            if (trustStoreUri == null) {
                throw new FileNotFoundException("cannot find trustore file in classpath: " + trustStoreLocation);
            }
            KeyStore jks = KeyStore.getInstance("JKS");
            jks.load(new FileInputStream(new File(trustStoreUri.getFile())), truststorePass.toCharArray());
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(jks);
            this.sslContext = SSLContext.getInstance("TLSv1.2");
            this.sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            return this.sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new MongoClientException("Cannot initialize mongo truststore", (Throwable)ex);
        }
    }

    public SSLContext getSslContext(String truststore, String truststorePass) {
        if (this.sslContext == null) {
            this.initSSLContext(truststore, truststorePass);
        }
        return this.sslContext;
    }
}

