/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.error;

import eu.europeana.api.commons_sb3.error.AbstractRequestPathMethodService;
import eu.europeana.api.commons_sb3.error.EuropeanaApiErrorResponse;
import eu.europeana.api.commons_sb3.error.EuropeanaApiException;
import eu.europeana.api.commons_sb3.error.EuropeanaI18nApiException;
import eu.europeana.api.commons_sb3.error.exceptions.InvalidBodyException;
import eu.europeana.api.commons_sb3.error.i18n.I18nService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Component
public class EuropeanaGlobalExceptionHandler {
    @Value(value="${server.error.include-stacktrace:ON_PARAM}")
    private ErrorProperties.IncludeStacktrace includeStacktraceConfig;
    private static final Logger LOG = LogManager.getLogger(EuropeanaGlobalExceptionHandler.class);
    protected AbstractRequestPathMethodService requestPathMethodService;
    @Resource(name="i18nService")
    protected I18nService i18nService;

    protected void logException(EuropeanaApiException e) {
        if (e.doLog()) {
            if (e.doLogStacktrace()) {
                LOG.error("Caught exception", (Throwable)e);
            } else {
                LOG.error("Caught exception: {}", (Object)e.getMessage());
            }
        }
    }

    protected boolean stackTraceEnabled() {
        return this.includeStacktraceConfig != ErrorProperties.IncludeStacktrace.NEVER;
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleEuropeanaBaseException(EuropeanaApiException e, HttpServletRequest httpRequest) {
        this.logException(e);
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, e, this.stackTraceEnabled()).setStatus(e.getResponseStatus().value()).setError(e.getResponseStatus().getReasonPhrase()).setMessage(e.doExposeMessage() ? e.getMessage() : null).setCode(e.getErrorCode()).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)e.getResponseStatus()).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler(value={InvalidBodyException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleEuropeanaApiException(InvalidBodyException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, e, this.stackTraceEnabled()).setStatus(e.getResponseStatus().value()).setError(e.getError()).setMessage(this.buildResponseMessage(e, e.getI18KeysAndParams())).setCode(e.getErrorCode()).build();
        LOG.error("Caught exception: {}", (Object)response.getMessage());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)e.getResponseStatus()).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    private String buildResponseMessage(Exception e, Map<String, List<String>> i18KeysAndParams) {
        System.out.println(i18KeysAndParams);
        if (this.i18nService != null && !i18KeysAndParams.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : i18KeysAndParams.entrySet()) {
                message.append(this.buildResponseMessage(e, entry.getKey(), entry.getValue()));
                message.append(" \n ");
            }
            return message.toString();
        }
        return e.getMessage();
    }

    @ExceptionHandler(value={EuropeanaI18nApiException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleEuropeanaApiException(EuropeanaI18nApiException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, e, this.stackTraceEnabled()).setStatus(e.getResponseStatus().value()).setError(e.getError()).setMessage(this.buildResponseMessage(e, e.getI18nKey(), e.getI18nParams())).setCode(e.getErrorCode()).build();
        LOG.error("Caught exception: {}", (Object)response.getMessage());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)e.getResponseStatus()).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    protected String buildResponseMessage(Exception e, String i18nKey, List<String> i18nParams) {
        if (this.i18nService != null && StringUtils.isNotBlank((CharSequence)i18nKey)) {
            return this.i18nService.getMessage(i18nKey, i18nParams.toArray(new String[0]));
        }
        return e.getMessage();
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleHttpMethodNotSupportedException(HttpRequestMethodNotSupportedException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.METHOD_NOT_ALLOWED;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage(e.getMessage()).build();
        Set supportedMethods = e.getSupportedHttpMethods();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (supportedMethods != null) {
            headers.setAllow(supportedMethods);
        }
        return new ResponseEntity((Object)response, (MultiValueMap)headers, (HttpStatusCode)responseStatus);
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleInputValidationError(ConstraintViolationException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage(e.getMessage()).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)responseStatus).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleInputValidationError(MissingServletRequestParameterException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage(e.getMessage()).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)responseStatus).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleMediaTypeNotAcceptableException(HttpMediaTypeNotAcceptableException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.NOT_ACCEPTABLE;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage("Server could not generate a response that is acceptable by the client").build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)responseStatus).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleMethodArgNotValidException(MethodArgumentNotValidException e, HttpServletRequest httpRequest) {
        BindingResult result = e.getBindingResult();
        Object error = "";
        List fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            error = ((FieldError)fieldErrors.get(0)).getField() + " " + ((FieldError)fieldErrors.get(0)).getDefaultMessage();
        }
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setMessage("Invalid request body").setError((String)error).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)responseStatus).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    protected HttpHeaders createHttpHeaders(HttpServletRequest httpRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (this.getRequestPathMethodService() != null) {
            String allowHeaderValue = this.getRequestPathMethodService().getMethodsForRequestPattern(httpRequest).orElse(httpRequest.getMethod());
            headers.add("Allow", allowHeaderValue);
        }
        return headers;
    }

    AbstractRequestPathMethodService getRequestPathMethodService() {
        return this.requestPathMethodService;
    }
}

