/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.error;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.api.commons_sb3.error.ResponseUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.util.StringUtils;

@JsonPropertyOrder(value={"@context", "type", "success", "status", "code", "error", "message", "seeAlso", "timestamp", "path", "trace"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class EuropeanaApiErrorResponse {
    @JsonProperty(value="@context")
    private final String context = "http://www.europeana.eu/schemas/context/api.jsonld";
    @JsonProperty(value="type")
    private final String type = "ErrorResponse";
    @JsonProperty(value="success")
    private final boolean success = false;
    @JsonProperty(value="status")
    private final int status;
    @JsonProperty(value="error")
    private final String error;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="seeAlso")
    private final String seeAlso = "https://pro.europeana.eu/page/apis";
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    private final OffsetDateTime timestamp = OffsetDateTime.now();
    @JsonProperty(value="trace")
    private final String trace;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="code")
    private final String code;

    private EuropeanaApiErrorResponse(int status, String error, String message, String trace, String path, String code) {
        this.status = status;
        this.error = error;
        this.message = message;
        this.trace = trace;
        this.path = path;
        this.code = code;
    }

    public String getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getPath() {
        return this.path;
    }

    public String getCode() {
        return this.code;
    }

    public String getContext() {
        return "http://www.europeana.eu/schemas/context/api.jsonld";
    }

    public String getType() {
        return "ErrorResponse";
    }

    public String getSeeAlso() {
        return "https://pro.europeana.eu/page/apis";
    }

    public static class Builder {
        private int status;
        private String message;
        private String error;
        private String trace;
        private final String path;
        private String code;

        public Builder(HttpServletRequest httpRequest, Exception e, boolean stacktraceEnabled) {
            this.path = ResponseUtils.getRequestPath(httpRequest);
            boolean includeErrorStack = false;
            String profileParamString = httpRequest.getParameter("profile");
            if (StringUtils.hasLength((String)profileParamString)) {
                includeErrorStack = List.of(profileParamString.split(",")).contains("debug");
            }
            if (stacktraceEnabled && includeErrorStack) {
                this.trace = ResponseUtils.getExceptionStackTrace(e);
            }
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public EuropeanaApiErrorResponse build() {
            return new EuropeanaApiErrorResponse(this.status, this.error, this.message, this.trace, this.path, this.code);
        }
    }
}

