/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.error;

import eu.europeana.api.commons_sb3.error.EuropeanaApiErrorAttributes;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
public class EuropeanaApiErrorController
extends AbstractErrorController {
    private final EuropeanaApiErrorAttributes errorAttributes;
    @Value(value="${server.error.include-message:always}")
    private ErrorProperties.IncludeAttribute includeMessage;
    @Value(value="${server.error.include-stacktrace:on_param}")
    private ErrorProperties.IncludeStacktrace includeStacktrace;
    @Value(value="${server.error.include-exception:true}")
    private Boolean includeException;

    @Autowired
    public EuropeanaApiErrorController(EuropeanaApiErrorAttributes errorAttributes) {
        super((ErrorAttributes)errorAttributes);
        this.errorAttributes = errorAttributes;
    }

    @GetMapping(value={"/error"})
    public Map<String, Object> error(HttpServletRequest request) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (ErrorProperties.IncludeAttribute.ON_PARAM.equals((Object)this.includeMessage) && this.getMessageParameter(request)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE});
        }
        if (ErrorProperties.IncludeStacktrace.ON_PARAM.equals((Object)this.includeStacktrace) && this.getTraceParameter(request)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE});
        }
        ServletWebRequest webRequest = new ServletWebRequest(request);
        return this.errorAttributes.getErrorAttributes((WebRequest)webRequest, options);
    }

    protected boolean getTraceParameter(HttpServletRequest request) {
        if (this.getBooleanParameter(request, "debug")) {
            return true;
        }
        String parameter = request.getParameter("profile");
        if (parameter == null) {
            return false;
        }
        return Arrays.stream(parameter.split("[+,]")).anyMatch("debug"::equalsIgnoreCase);
    }
}

