/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.error;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.api.commons_sb3.error.ResponseUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.util.StringUtils;

@JsonPropertyOrder(value={"@context", "type", "success", "status", "code", "error", "message", "seeAlso", "timestamp", "path", "trace"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class EuropeanaApiErrorResponse {
    @JsonProperty(value="@context")
    private final String context = "http://www.europeana.eu/schemas/context/api.jsonld";
    private final String type = "ErrorResponse";
    private final boolean success = false;
    private final int status;
    private final String error;
    private final String message;
    private final String seeAlso;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    private final OffsetDateTime timestamp = OffsetDateTime.now();
    private final String trace;
    private final String path;
    private final String code;

    private EuropeanaApiErrorResponse(int status, String code, String error, String message, String seeAlso, String path, String trace) {
        this.status = status;
        this.code = code;
        this.error = error;
        this.message = message;
        this.seeAlso = seeAlso;
        this.path = path;
        this.trace = trace;
    }

    public String getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getPath() {
        return this.path;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return "ErrorResponse";
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public static class Builder {
        private int status;
        private String message;
        private String error;
        private String trace;
        private final String path;
        private String code;
        private String seeAlso;

        public Builder(HttpServletRequest httpRequest, Exception e, boolean stacktraceEnabled) {
            this.path = ResponseUtils.getRequestPath(httpRequest);
            boolean includeErrorStack = false;
            String profileParamString = httpRequest.getParameter("profile");
            if (StringUtils.hasLength((String)profileParamString)) {
                includeErrorStack = List.of(profileParamString.split(",")).contains("debug");
            }
            if (stacktraceEnabled && includeErrorStack) {
                this.trace = ResponseUtils.getExceptionStackTrace(e);
            }
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setSeeAlso(String seeAlso) {
            this.seeAlso = seeAlso;
            return this;
        }

        public EuropeanaApiErrorResponse build() {
            return new EuropeanaApiErrorResponse(this.status, this.code, this.error, this.message, this.seeAlso, this.path, this.trace);
        }
    }
}

