/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.error;

import eu.europeana.api.commons_sb3.error.EuropeanaApiException;
import java.time.OffsetDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequest;

@Component(value="europeanaApiErrorAttributes")
public class EuropeanaApiErrorAttributes
extends DefaultErrorAttributes {
    @Value(value="${server.error.see-also:#{null}}")
    private String seeAlsoValue;

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions sbOptions) {
        Map defaultErrorAttributes = super.getErrorAttributes(webRequest, sbOptions);
        LinkedHashMap<String, Object> europeanaErrorAttributes = new LinkedHashMap<String, Object>();
        europeanaErrorAttributes.put("@context", "http://www.europeana.eu/schemas/context/api.jsonld");
        europeanaErrorAttributes.put("type", "ErrorResponse");
        europeanaErrorAttributes.put("success", false);
        europeanaErrorAttributes.put("status", defaultErrorAttributes.get("status"));
        europeanaErrorAttributes.put("error", defaultErrorAttributes.get("error"));
        this.addCodeFieldIfAvailable(europeanaErrorAttributes, webRequest);
        if (defaultErrorAttributes.get("message") != null) {
            europeanaErrorAttributes.put("message", defaultErrorAttributes.get("message"));
        }
        if (StringUtils.hasLength((String)this.seeAlsoValue)) {
            europeanaErrorAttributes.put("seeAlso", this.seeAlsoValue);
        }
        europeanaErrorAttributes.put("timestamp", OffsetDateTime.now());
        this.addPathRequestParameters(europeanaErrorAttributes, webRequest);
        if (defaultErrorAttributes.get("trace") != null) {
            europeanaErrorAttributes.put("trace", defaultErrorAttributes.get("trace"));
        }
        return europeanaErrorAttributes;
    }

    private void addCodeFieldIfAvailable(Map<String, Object> errorAttributes, WebRequest webRequest) {
        EuropeanaApiException apiException;
        Throwable throwable = super.getError(webRequest);
        if (throwable instanceof EuropeanaApiException && StringUtils.hasLength((String)(apiException = (EuropeanaApiException)throwable).getErrorCode())) {
            errorAttributes.put("code", apiException.getErrorCode());
        }
    }

    private void addPathRequestParameters(Map<String, Object> errorAttributes, WebRequest webRequest) {
        Iterator it = webRequest.getParameterNames();
        StringBuilder params = new StringBuilder();
        while (it.hasNext()) {
            if (params.length() == 0) {
                params.append('?');
            } else {
                params.append("&");
            }
            String paramName = (String)it.next();
            params.append(paramName);
            String paramValue = webRequest.getParameter(paramName);
            if (!StringUtils.hasText((String)paramValue)) continue;
            params.append("=").append(paramValue);
        }
        if (params.length() > 0) {
            errorAttributes.put("path", errorAttributes.get("path") + params.toString());
        }
    }
}

