/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.error;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class AbstractRequestPathMethodService
implements InitializingBean {
    private final Map<String, Set<String>> requestPathMethodMap = new HashMap<String, Set<String>>();
    protected final WebApplicationContext applicationContext;

    protected AbstractRequestPathMethodService(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map handlerMethods = mapping.getHandlerMethods();
        for (RequestMappingInfo info : handlerMethods.keySet()) {
            PatternsRequestCondition p = info.getPatternsCondition();
            Set<String> requestMethods = info.getMethodsCondition().getMethods().stream().map(Enum::toString).collect(Collectors.toSet());
            if (p == null) continue;
            for (String url : p.getPatterns()) {
                this.addToMap(this.requestPathMethodMap, url, requestMethods);
            }
        }
    }

    public Optional<String> getMethodsForRequestPattern(HttpServletRequest request) {
        Object patternAttribute = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (patternAttribute == null) {
            return Optional.empty();
        }
        Set<String> requestMethods = this.requestPathMethodMap.get(patternAttribute.toString());
        if (requestMethods == null) {
            return Optional.empty();
        }
        String methods = String.join((CharSequence)",", requestMethods);
        return Optional.of(methods);
    }

    private void addToMap(Map<String, Set<String>> map, String urlPattern, Set<String> requestMethods) {
        map.computeIfAbsent(urlPattern, k -> requestMethods);
        Set<String> existing = map.get(urlPattern);
        existing.addAll(requestMethods);
    }
}

