/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpResponseHandler
implements HttpClientResponseHandler<Void> {
    private String response;
    private int status;
    private String locationHeader;
    private List<Header> cachingHeaders;

    public Void handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
        this.status = response.getCode();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            this.response = EntityUtils.toString((HttpEntity)entity);
        }
        this.cachingHeaders = new ArrayList<Header>(3);
        this.getHeaders(response);
        return null;
    }

    private void getHeaders(ClassicHttpResponse response) {
        this.cachingHeaders = new ArrayList<Header>(3);
        Iterator headers = response.headerIterator();
        while (headers.hasNext()) {
            Header header = (Header)headers.next();
            if (StringUtils.equalsAny((CharSequence)header.getName(), (CharSequence[])new CharSequence[]{"ETag", "Last-Modified", "Cache-Control"})) {
                this.cachingHeaders.add(header);
            }
            if (!StringUtils.equals((CharSequence)header.getName(), (CharSequence)"Location")) continue;
            this.locationHeader = header.getValue();
        }
    }

    public String getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.status;
    }

    public String getLocationHeader() {
        return this.locationHeader;
    }

    public List<Header> getCachingHeaders() {
        return this.cachingHeaders;
    }
}

