/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.http;

import eu.europeana.api.commons_sb3.auth.AuthenticationHandler;
import eu.europeana.api.commons_sb3.http.HttpResponseHandler;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class HttpConnection {
    private final CloseableHttpClient httpClient;

    public HttpConnection() {
        this(false);
    }

    public HttpConnection(boolean withRedirect) {
        if (withRedirect) {
            RequestConfig requestConfig = RequestConfig.custom().setCircularRedirectsAllowed(true).build();
            this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
        } else {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.disableRedirectHandling();
            this.httpClient = clientBuilder.build();
        }
    }

    public HttpResponseHandler get(String url, String acceptHeaderValue, AuthenticationHandler auth) throws IOException {
        HttpGet get = new HttpGet(url);
        if (StringUtils.isNotBlank((CharSequence)acceptHeaderValue)) {
            this.addHeaders(get, "Accept", acceptHeaderValue);
        }
        if (auth != null) {
            auth.setAuthorization((HttpRequest)get);
        }
        return this.executeHttpClient(get);
    }

    public HttpResponseHandler post(String url, String requestBody, String contentType, AuthenticationHandler auth) throws IOException {
        HttpPost post = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            this.addHeaders(post, "Content-Type", contentType);
        }
        auth.setAuthorization((HttpRequest)post);
        if (requestBody != null) {
            post.setEntity((HttpEntity)new StringEntity(requestBody));
        }
        return this.executeHttpClient(post);
    }

    public HttpResponseHandler put(String url, String jsonParamValue, AuthenticationHandler auth) throws IOException {
        HttpPut put = new HttpPut(url);
        auth.setAuthorization((HttpRequest)put);
        put.setEntity((HttpEntity)new StringEntity(jsonParamValue));
        return this.executeHttpClient(put);
    }

    public HttpResponseHandler deleteURL(String url, AuthenticationHandler auth) throws IOException {
        HttpDelete delete = new HttpDelete(url);
        auth.setAuthorization((HttpRequest)delete);
        return this.executeHttpClient(delete);
    }

    private <T extends HttpUriRequestBase> HttpResponseHandler executeHttpClient(T url) throws IOException {
        HttpResponseHandler responseHandler = new HttpResponseHandler();
        this.httpClient.execute(url, (HttpClientResponseHandler)responseHandler);
        return responseHandler;
    }

    private <T extends HttpUriRequestBase> void addHeaders(T url, String headerName, String headerValue) {
        if (StringUtils.isNotBlank((CharSequence)headerValue)) {
            url.setHeader(headerName, (Object)headerValue);
        }
    }
}

