/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.http;

import eu.europeana.api.commons_sb3.auth.AuthenticationHandler;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpRequest;

public class AsyncHttpConnection {
    private final CloseableHttpAsyncClient httpClient;

    public AsyncHttpConnection() {
        this(false);
    }

    public AsyncHttpConnection(boolean withRedirect) {
        PoolingAsyncClientConnectionManager connPool = new PoolingAsyncClientConnectionManager();
        if (withRedirect) {
            RequestConfig requestConfig = RequestConfig.custom().setCircularRedirectsAllowed(true).build();
            this.httpClient = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connPool).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
        } else {
            this.httpClient = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connPool).disableRedirectHandling().build();
        }
    }

    public AsyncHttpConnection(PoolingAsyncClientConnectionManager connectionPool) {
        RequestConfig requestConfig = RequestConfig.custom().setCircularRedirectsAllowed(true).build();
        this.httpClient = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connectionPool).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
    }

    public void start() {
        this.httpClient.start();
    }

    public SimpleHttpResponse get(String url, String acceptHeaderValue, AuthenticationHandler auth) throws ExecutionException, InterruptedException {
        SimpleHttpRequest httpRequest = new SimpleHttpRequest("GET", url);
        if (StringUtils.isNotBlank((CharSequence)acceptHeaderValue)) {
            httpRequest.setHeader("Accept", (Object)acceptHeaderValue);
        }
        if (auth != null) {
            auth.setAuthorization((HttpRequest)httpRequest);
        }
        return (SimpleHttpResponse)this.httpClient.execute(httpRequest, null).get();
    }

    public SimpleHttpResponse post(String url, String requestBody, String contentType, AuthenticationHandler auth) throws ExecutionException, InterruptedException {
        SimpleHttpRequest httpRequest = new SimpleHttpRequest("POST", url);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            httpRequest.setHeader("Content-Type", (Object)contentType);
        }
        if (auth != null) {
            auth.setAuthorization((HttpRequest)httpRequest);
        }
        if (requestBody != null) {
            httpRequest.setBody(requestBody, ContentType.create((String)contentType));
        }
        return (SimpleHttpResponse)this.httpClient.execute(httpRequest, null).get();
    }

    public SimpleHttpResponse put(String url, String jsonParamValue, AuthenticationHandler auth) throws ExecutionException, InterruptedException {
        SimpleHttpRequest httpRequest = new SimpleHttpRequest("PUT", url);
        if (auth != null) {
            auth.setAuthorization((HttpRequest)httpRequest);
        }
        if (jsonParamValue != null) {
            httpRequest.setBody(jsonParamValue, null);
        }
        return (SimpleHttpResponse)this.httpClient.execute(httpRequest, null).get();
    }

    public SimpleHttpResponse deleteURL(String url, AuthenticationHandler auth) throws ExecutionException, InterruptedException {
        SimpleHttpRequest httpRequest = new SimpleHttpRequest("DELETE", url);
        auth.setAuthorization((HttpRequest)httpRequest);
        return (SimpleHttpResponse)this.httpClient.execute(httpRequest, null).get();
    }

    public void close() throws IOException {
        this.httpClient.close();
    }
}

