/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.auth.token;

import eu.europeana.api.commons_sb3.auth.service.AuthGrant;
import eu.europeana.api.commons_sb3.auth.service.AuthenticationService;
import eu.europeana.api.commons_sb3.auth.service.TokenResponse;
import eu.europeana.api.commons_sb3.auth.token.TokenBasedAuthentication;

public class LongLastingTokenAuthentication
extends TokenBasedAuthentication {
    private boolean offline;
    private AuthenticationService authService;
    private AuthGrant grant;
    private TokenResponse tokenResponse;

    public LongLastingTokenAuthentication(AuthenticationService authService, AuthGrant grant, boolean offline) {
        this.authService = authService;
        this.grant = grant;
        this.offline = offline;
    }

    public LongLastingTokenAuthentication(AuthenticationService authService, AuthGrant grant) {
        this(authService, grant, true);
    }

    @Override
    protected String getAccessToken() {
        AuthGrant grant = this.grant;
        if (this.tokenResponse == null || !this.offline) {
            this.tokenResponse = this.authService.newToken(grant);
            return this.tokenResponse.accessToken();
        }
        if (!this.tokenResponse.hasTokenExpired()) {
            return this.tokenResponse.accessToken();
        }
        if (this.tokenResponse.canRefresh()) {
            grant = this.grant.newRefreshGrant(this.tokenResponse.refreshToken());
        }
        this.tokenResponse = this.authService.newToken(grant);
        return this.tokenResponse.accessToken();
    }
}

