/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.auth.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public record TokenResponse(String accessToken, Long expirationTime, String refreshToken, Long refreshExpirationTime, String tokenScope, String sessionState) {
    public TokenResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="expires_in") Long expirationTime, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="refresh_expires_in") Long refreshExpirationTime, @JsonProperty(value="scope") String tokenScope, @JsonProperty(value="session_state") String sessionState) {
        long now = TokenResponse.now();
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expirationTime = TokenResponse.getExpirationTime(now, expirationTime);
        this.refreshExpirationTime = TokenResponse.getExpirationTime(now, refreshExpirationTime);
        this.tokenScope = tokenScope;
        this.sessionState = sessionState;
    }

    private static long getExpirationTime(long now, long expiresIn) {
        return now + expiresIn - 60L;
    }

    private static long now() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    public boolean hasTokenExpired() {
        return this.expirationTime() < TokenResponse.now();
    }

    public boolean hasRefreshTokenExpired() {
        return this.refreshExpirationTime() < TokenResponse.now();
    }

    public boolean canRefresh() {
        return this.refreshToken() != null && !this.hasRefreshTokenExpired();
    }
}

