/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.auth.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.europeana.api.commons_sb3.auth.AuthenticationException;
import eu.europeana.api.commons_sb3.auth.service.AuthGrant;
import eu.europeana.api.commons_sb3.auth.service.TokenResponse;
import eu.europeana.api.commons_sb3.http.HttpResponseHandler;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class AuthenticationService {
    private final CloseableHttpClient httpClient;
    private String tokenEndpoint;
    private ObjectMapper objMapper = AuthenticationService.buildMapper();

    public AuthenticationService(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        this.httpClient = HttpClientBuilder.create().build();
    }

    public TokenResponse newToken(AuthGrant grant) throws AuthenticationException {
        try {
            HttpResponseHandler rsp = new HttpResponseHandler();
            this.httpClient.execute((ClassicHttpRequest)this.newTokenRequest(grant), (HttpClientResponseHandler)rsp);
            if (rsp.getStatus() != 200) {
                AuthenticationException e = (AuthenticationException)this.objMapper.readerFor(AuthenticationException.class).readValue(rsp.getResponse());
                throw e;
            }
            return (TokenResponse)this.objMapper.readerFor(TokenResponse.class).readValue(rsp.getResponse());
        }
        catch (IOException e) {
            throw new AuthenticationException("Error connecting to auth endpoint", e);
        }
    }

    private HttpPost newTokenRequest(AuthGrant grant) {
        HttpPost post = new HttpPost(this.tokenEndpoint);
        post.setEntity(grant.getEntity());
        return post;
    }

    public static ObjectMapper buildMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        mapper.registerModule((Module)module);
        mapper.setVisibility(mapper.getVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.findAndRegisterModules();
        return mapper;
    }
}

