/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.auth.service;

import eu.europeana.api.commons_sb3.auth.service.GrantConstants;
import eu.europeana.api.commons_sb3.auth.service.GrantType;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class AuthGrant
extends Properties {
    private static final long serialVersionUID = 1L;

    public AuthGrant(Properties args) {
        super(args);
        this.keySet().retainAll(GrantConstants.params);
    }

    public AuthGrant(String args) {
        this.parse(args);
        this.keySet().retainAll(GrantConstants.params);
    }

    public HttpEntity getEntity() {
        StringBuilder sb = new StringBuilder();
        for (Object key : this.keySet()) {
            String str;
            Object value = this.get(key);
            if (value == null || StringUtils.isBlank((CharSequence)(str = value.toString()))) continue;
            if (!sb.isEmpty()) {
                sb.append("&");
            }
            sb.append(key.toString()).append("=").append(str);
        }
        return new StringEntity(sb.toString(), ContentType.APPLICATION_FORM_URLENCODED);
    }

    public AuthGrant newRefreshGrant(String refreshToken) {
        Properties props = new Properties(this);
        props.put("grant_type", (Object)GrantType.refresh_token);
        props.put("refresh_token", refreshToken);
        return new AuthGrant(props);
    }

    private void parse(String args) {
        if (args.contains("&")) {
            for (String line : args.split("&")) {
                String[] arg = line.split("=");
                if (arg.length != 2) continue;
                this.setProperty(arg[0], arg[1]);
            }
            return;
        }
        if (args.contains("\n")) {
            for (String line : args.split("\n")) {
                String[] arg = line.split(":");
                if (arg.length != 2) continue;
                this.setProperty(arg[0], arg[1]);
            }
        }
    }
}

