/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.commons_sb3.auth;

import eu.europeana.api.commons_sb3.auth.AuthenticationConfig;
import eu.europeana.api.commons_sb3.auth.AuthenticationException;
import eu.europeana.api.commons_sb3.auth.AuthenticationHandler;
import eu.europeana.api.commons_sb3.auth.apikey.ApikeyBasedAuthentication;
import eu.europeana.api.commons_sb3.auth.service.AuthenticationService;
import eu.europeana.api.commons_sb3.auth.token.LongLastingTokenAuthentication;
import eu.europeana.api.commons_sb3.auth.token.StaticTokenAuthentication;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationBuilder {
    public static AuthenticationHandler newAuthentication(AuthenticationConfig config) {
        String accessToken = config.getAccessToken();
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            return new StaticTokenAuthentication(accessToken);
        }
        String endpointUri = config.getAuthTokenEndpoitUri();
        if (StringUtils.isNotBlank((CharSequence)endpointUri)) {
            AuthenticationService service = new AuthenticationService(endpointUri);
            return new LongLastingTokenAuthentication(service, config.getAuthGrant());
        }
        String apikey = config.getApiKey();
        if (StringUtils.isNotBlank((CharSequence)apikey)) {
            return new ApikeyBasedAuthentication(apikey);
        }
        throw new AuthenticationException("Missing configuration for authentication");
    }
}

