/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.myapi.web;

import eu.europeana.api.commons_sb3.error.EuropeanaApiException;
import eu.europeana.api.myapi.exception.DummyException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class MyApiController {
    private static final String MY_REGEX = "^[a-zA-Z0-9]*$";
    private static final String INVALID_REQUEST_MESSAGE = "Invalid parameter.";

    @GetMapping(value={"/myApi/{path}"}, produces={"application/json"})
    public String handleMyApiRequest(@PathVariable(value="path") @Pattern(regexp="^[a-zA-Z0-9]*$", message="Invalid parameter.") @Pattern(regexp="^[a-zA-Z0-9]*$", message="Invalid parameter.") String somePath) {
        return "{ \"You requested\": \"" + somePath + "\" }";
    }

    @GetMapping(value={"myApi/dummyError"})
    public void generateError(HttpServletRequest request) throws EuropeanaApiException {
        if (request.getParameterMap().containsKey("trace") || request.getParameterMap().containsKey("debug")) {
            throw new DummyException("This is an error with stacktrace", "MyErrorCode");
        }
        throw new DummyException("This is an error. You can see a stacktrace if you add a 'trace' or 'debug' parameter", "MyErrorCode");
    }
}

