/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.validation;

import eu.europeana.annotation.config.AnnotationConfiguration;
import eu.europeana.annotation.definitions.model.Address;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.agent.impl.EdmAgent;
import eu.europeana.annotation.definitions.model.body.Body;
import eu.europeana.annotation.definitions.model.body.PlaceBody;
import eu.europeana.annotation.definitions.model.body.impl.EdmAgentBody;
import eu.europeana.annotation.definitions.model.body.impl.VcardAddressBody;
import eu.europeana.annotation.definitions.model.entity.Place;
import eu.europeana.annotation.definitions.model.resource.SpecificResource;
import eu.europeana.annotation.definitions.model.target.Target;
import eu.europeana.annotation.definitions.model.vocabulary.BodyInternalTypes;
import eu.europeana.annotation.definitions.model.vocabulary.ResourceTypes;
import eu.europeana.annotation.fulltext.exception.MediaTypeValidationException;
import eu.europeana.annotation.fulltext.subtitles.SubtitleHandler;
import eu.europeana.annotation.fulltext.transcription.TranscriptionFormatValidator;
import eu.europeana.annotation.fulltext.transcription.XmlValidationErrorCollector;
import eu.europeana.annotation.utils.GeneralUtils;
import eu.europeana.annotation.web.exception.request.ParamValidationI18NException;
import eu.europeana.annotation.web.exception.request.PropertyValidationException;
import eu.europeana.annotation.web.exception.request.RequestBodyValidationException;
import eu.europeana.annotation.web.model.vocabulary.UserRoles;
import eu.europeana.annotation.web.service.authorization.AnnotationAuthorizationUtils;
import eu.europeana.annotation.web.validation.BaseAnnotationValidator;
import java.net.URI;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.xml.sax.SAXParseException;

public abstract class BaseAnnotationValidator {
    private static final String TRANSCRIPTION_TARGET_SOURCE = "transcription.target.source";
    private static final String BODY_EDM_RIGHTS = "body.edmRights";
    private static final String TARGET = "target";
    private static final String BODY_FORMAT = "body.format";
    private static final String BODY_VALUE = "body.value";
    private static final String BODY = "body";
    private static final String TRANSCRIPTION_BODY_VALUE = "transcription.body.value";
    private static final String TRANSCRIPTION_BODY_LANGUAGE = "transcription.body.language";
    private static final String TRANSCRIPTION_BODY_FORMAT = "transcription.body.format";
    private static final String BODY_SOURCE = "body.source";
    private static final String BODY_TYPE = "body.type";
    private static final String TAG_BODY_LONGITUDE = "tag.body.longitude";
    private static final String TAG_BODY_LATITUDE = "tag.body.latitude";
    private static final String AGENT_BODY_PREF_LABEL = "agent.body.prefLabel";
    @Resource(name="subtitleHandler")
    private SubtitleHandler subtitleHandler;
    @Resource(name="mediaFormatValidator")
    private TranscriptionFormatValidator mediaFormatValidator;

    protected abstract AnnotationConfiguration getConfiguration();

    protected abstract boolean validateResource(String var1) throws ParamValidationI18NException;

    void validateAgentBody(Body body) throws ParamValidationI18NException, PropertyValidationException {
        if (body.getType() == null || body.getType().size() != 1) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_TYPE});
        }
        if (!ResourceTypes.AGENT.hasJsonValue((String)body.getType().get(0))) {
            throw new PropertyValidationException("error.annotation_invalid_property_value", "error.annotation_invalid_property_value", new String[]{BODY_TYPE});
        }
        this.validateAgentEntityBody(body);
    }

    void validateAgentEntityBody(Body body) throws PropertyValidationException {
        EdmAgent agent = (EdmAgent)((EdmAgentBody)body).getAgent();
        if (agent.getPrefLabel() == null) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{AGENT_BODY_PREF_LABEL});
        }
        if (body.getType() == null || StringUtils.isBlank((CharSequence)((CharSequence)body.getType().get(0)))) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_TYPE});
        }
    }

    void validateGeoTag(Body body) throws ParamValidationI18NException {
        if (!(body instanceof PlaceBody)) {
            throw new ParamValidationI18NException("error.annotation_invalid_property_value", "error.annotation_invalid_property_value", new String[]{BODY_TYPE, ResourceTypes.PLACE.toString()});
        }
        Place place = ((PlaceBody)body).getPlace();
        if (StringUtils.isEmpty((CharSequence)place.getLatitude())) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TAG_BODY_LATITUDE});
        }
        if (StringUtils.isEmpty((CharSequence)place.getLongitude())) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TAG_BODY_LONGITUDE});
        }
    }

    void validateTagWithSpecificResource(Body body) throws ParamValidationI18NException {
        if (StringUtils.isBlank((CharSequence)body.getInternalType())) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_TYPE});
        }
        if (StringUtils.isBlank((CharSequence)body.getSource())) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_SOURCE});
        }
        this.validateSpecificResource((SpecificResource)body, BODY, false);
    }

    private void validateSpecificResource(SpecificResource resource, String fieldName, boolean isScopeMandatory) throws ParamValidationI18NException {
        if (resource.getSource() == null || !GeneralUtils.isUrl((String)resource.getSource())) {
            throw new ParamValidationI18NException("Invalid tag format. The source of a SpecificResource must be an URL!", "error.message_invalid_tag_specific_resource", new String[]{fieldName + ".source", resource.getSource()});
        }
        if (resource.getHttpUri() != null && !GeneralUtils.isUrl((String)resource.getHttpUri())) {
            throw new ParamValidationI18NException("Invalid tag format. The internal id must be an URL!", "error.message_invalid_tag_id_format", new String[]{fieldName + ".httpUri", resource.getHttpUri()});
        }
        if (resource.getScope() == null) {
            if (isScopeMandatory) {
                throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{fieldName + ".scope"});
            }
        } else if (!GeneralUtils.isUrl((String)resource.getScope())) {
            throw new ParamValidationI18NException("Invalid tag format. The source of a SpecificResource must be an URL!", "error.message_invalid_tag_specific_resource", new String[]{fieldName + ".scope", resource.getScope()});
        }
    }

    protected void validateTranscriptionBodyWithFullTextResource(Body body, Authentication authentication) throws ParamValidationI18NException, PropertyValidationException, RequestBodyValidationException {
        this.validateFullTextResource(body);
        this.validateEdmRights(body, authentication);
        String bodyFormat = body.getContentType();
        if (StringUtils.isBlank((CharSequence)bodyFormat)) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TRANSCRIPTION_BODY_FORMAT});
        }
        this.validateTranscriptionBody(body);
    }

    private void validateTranscriptionBody(Body body) throws PropertyValidationException {
        String mimeType = body.getContentType();
        try {
            XmlValidationErrorCollector xmlErrorCollector = this.mediaFormatValidator.validateMediaFormat(body.getValue(), mimeType);
            if (xmlErrorCollector != null && xmlErrorCollector.hasErrors()) {
                throw new PropertyValidationException("error.annotation_invalid_media_format", "error.annotation_invalid_media_format", new String[]{xmlErrorCollector.getValidationErrors()});
            }
        }
        catch (MediaTypeValidationException e) {
            HttpStatus responseStatus = this.isXmlParseException(e) ? HttpStatus.BAD_REQUEST : HttpStatus.UNSUPPORTED_MEDIA_TYPE;
            throw new PropertyValidationException("error.annotation_transcription_validation", "error.annotation_transcription_validation", new String[]{mimeType}, responseStatus, (Throwable)e);
        }
    }

    private boolean isXmlParseException(MediaTypeValidationException e) {
        return e.getCause() != null && e.getCause() instanceof SAXParseException;
    }

    private void validateFullTextResource(Body body) throws PropertyValidationException {
        if (body.getType() != null && body.getType().size() == 1 && !ResourceTypes.FULL_TEXT_RESOURCE.hasJsonValue((String)body.getType().get(0))) {
            throw new PropertyValidationException("error.annotation_invalid_property_value", "error.annotation_invalid_property_value", new String[]{BODY_TYPE, ResourceTypes.FULL_TEXT_RESOURCE.getJsonValue()});
        }
        if (StringUtils.isBlank((CharSequence)body.getLanguage())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TRANSCRIPTION_BODY_LANGUAGE});
        }
        if (StringUtils.isBlank((CharSequence)body.getValue())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TRANSCRIPTION_BODY_VALUE});
        }
    }

    protected void validateVcardAddressBody(Body body) throws ParamValidationI18NException, PropertyValidationException {
        this.validateSemanticTagVcardAddressBody(body);
    }

    void validateSemanticTagVcardAddressBody(Body body) throws PropertyValidationException {
        if (body.getType() != null && body.getType().size() == 1 && !ResourceTypes.VCARD_ADDRESS.hasJsonValue((String)body.getType().get(0))) {
            throw new PropertyValidationException("error.annotation_invalid_property_value", "error.annotation_invalid_property_value", new String[]{"vcardAddress.body.type"});
        }
        Address address = ((VcardAddressBody)body).getAddress();
        if (StringUtils.isBlank((CharSequence)address.getVcardStreetAddress())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"tag.body.address.streetAddress"});
        }
        if (StringUtils.isBlank((CharSequence)address.getVcardLocality())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"tag.body.address.locality"});
        }
        if (StringUtils.isBlank((CharSequence)address.getVcardCountryName())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"tag.body.address.countryName"});
        }
        if (body.getType() == null || StringUtils.isBlank((CharSequence)((CharSequence)body.getType().get(0)))) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"tag.body.address.type"});
        }
    }

    protected void validateTextualBody(Body body, boolean isLanguageMandatory) throws ParamValidationI18NException, PropertyValidationException {
        if (StringUtils.isBlank((CharSequence)body.getValue())) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"tag.body.value"});
        }
        if (isLanguageMandatory && StringUtils.isBlank((CharSequence)body.getLanguage())) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"tag.body.language"});
        }
        if (body.getType() == null || !this.isTextualBodyType(body)) {
            throw new ParamValidationI18NException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_TYPE});
        }
    }

    private boolean isTextualBodyType(Body body) {
        return ResourceTypes.EXTERNAL_TEXT.hasJsonValue((String)body.getType().get(0)) || ResourceTypes.TEXTUAL_BODY.hasJsonValue((String)body.getType().get(0));
    }

    void validateTagWithValue(Body body) throws ParamValidationI18NException {
        String value = body.getValue();
        if ((value = value.trim()).startsWith("\"")) {
            int secondPosition = 1;
            value = value.substring(secondPosition);
            value = value.trim();
        }
        if (value.endsWith("\"")) {
            int secondLastPosition = value.length() - 1;
            value = value.substring(0, secondLastPosition);
            value = value.trim();
        }
        body.setValue(value);
        int MaxTagLength = 64;
        if (GeneralUtils.isUrl((String)value)) {
            throw new ParamValidationI18NException("Invalid tag format. A tag can't contain URLs!", "error.message_invalid_simple_tag", new String[]{value});
        }
        if (value.length() > MaxTagLength) {
            throw new ParamValidationI18NException("Invalid tag size. Must be shorter then 64 characters!", "error.message_invalid_tag_size", new String[]{String.valueOf(value.length())});
        }
    }

    public void validateWebAnnotation(Annotation webAnnotation, Authentication authentication) throws ParamValidationI18NException, RequestBodyValidationException, PropertyValidationException {
        if (webAnnotation.getCanonical() != null) {
            try {
                URI cannonicalUri = URI.create(webAnnotation.getCanonical());
                if (!cannonicalUri.isAbsolute()) {
                    throw new ParamValidationI18NException("The canonical URI is not absolute:", "error.annotation_validation", new String[]{"canonical", webAnnotation.getCanonical()});
                }
            }
            catch (IllegalArgumentException e) {
                throw new ParamValidationI18NException("Error when validating canonical URI:", "error.annotation_validation", new String[]{"canonical", webAnnotation.getCanonical()}, (Throwable)e);
            }
        }
        if (webAnnotation.getVia() != null && webAnnotation.getVia() instanceof String[]) {
            for (String via : webAnnotation.getVia()) {
                if (GeneralUtils.isUrl((String)via)) continue;
                throw new ParamValidationI18NException("This is not a valid URL:", "error.annotation_validation", new String[]{"via", via});
            }
        }
        switch (1.$SwitchMap$eu$europeana$annotation$definitions$model$vocabulary$MotivationTypes[webAnnotation.getMotivationType().ordinal()]) {
            case 1: {
                this.validateLinking(webAnnotation);
                break;
            }
            case 2: {
                this.validateDescribing(webAnnotation);
                break;
            }
            case 3: {
                this.validateTag(webAnnotation);
                break;
            }
            case 4: {
                this.validateTranscription(webAnnotation, authentication);
                break;
            }
            case 5: {
                this.validateSubtitleOrCaption(webAnnotation, authentication);
                break;
            }
            case 6: {
                this.validateSubtitleOrCaption(webAnnotation, authentication);
                break;
            }
            case 7: {
                this.validateLinkForContributing(webAnnotation);
                break;
            }
        }
    }

    void validateEdmRights(Body body, Authentication authentication) throws RequestBodyValidationException, PropertyValidationException {
        if (StringUtils.isBlank((CharSequence)body.getEdmRights())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_EDM_RIGHTS});
        }
        if (AnnotationAuthorizationUtils.hasRole((Authentication)authentication, (String)UserRoles.publisher.getName())) {
            return;
        }
        String rightsClaim = body.getEdmRights();
        String licence = null;
        char PathDelimiter = '/';
        long delimiterCount = rightsClaim.chars().filter(ch -> ch == PathDelimiter).count();
        if (delimiterCount < 6L || !rightsClaim.endsWith("" + PathDelimiter)) {
            throw new RequestBodyValidationException(body.getInputString(), "annotation_invalid_rights", new String[]{rightsClaim});
        }
        licence = rightsClaim.substring(0, rightsClaim.length() - 1);
        int versionStart = licence.lastIndexOf(PathDelimiter) + 1;
        licence = licence.substring(0, versionStart);
        Set rights = this.getConfiguration().getAcceptedLicenceses();
        if (!rights.contains(licence)) {
            throw new RequestBodyValidationException(body.getInputString(), "error.invalid_param_value", new String[]{BODY_EDM_RIGHTS, rightsClaim});
        }
    }

    protected void validateTag(Annotation webAnnotation) throws ParamValidationI18NException, PropertyValidationException {
        Body body = webAnnotation.getBody();
        this.validateBodyExists(webAnnotation.getBody());
        if (body.getType() != null && body.getType().contains("SpecificResource")) {
            this.validateTagWithSpecificResource(body);
        } else if (!BodyInternalTypes.isSemanticTagBody((String)body.getInternalType())) {
            if (BodyInternalTypes.isAgentBodyTag((String)body.getInternalType())) {
                this.validateAgentBody(body);
            } else if (BodyInternalTypes.isGeoTagBody((String)body.getInternalType())) {
                this.validateGeoTag(body);
            } else if (BodyInternalTypes.isVcardAddressTagBody((String)body.getInternalType())) {
                this.validateVcardAddressBody(body);
            } else {
                this.validateTagWithValue(body);
            }
        }
    }

    protected void validateLinking(Annotation webAnnotation) throws ParamValidationI18NException, PropertyValidationException {
        if (webAnnotation.getTarget() != null) {
            this.validateTargetBaseUrl(webAnnotation.getTarget());
            if (webAnnotation.getTarget().getValue() != null) {
                this.validateResource(webAnnotation.getTarget().getValue());
            }
            if (webAnnotation.getTarget().getValues() != null) {
                for (String url : webAnnotation.getTarget().getValues()) {
                    this.validateResource(url);
                }
            }
        }
    }

    protected void validateDescribing(Annotation webAnnotation) throws ParamValidationI18NException, PropertyValidationException {
        Body body = webAnnotation.getBody();
        this.validateBodyExists(webAnnotation.getBody());
        if (body.getType() != null && !ResourceTypes.EXTERNAL_TEXT.hasJsonValue((String)body.getType().get(0))) {
            this.validateTextualBody(body, true);
        }
        if (webAnnotation.getTarget() != null) {
            this.validateTargetBaseUrl(webAnnotation.getTarget());
        }
    }

    protected void validateTranscription(Annotation webAnnotation, Authentication authentication) throws ParamValidationI18NException, RequestBodyValidationException, PropertyValidationException {
        this.validateBodyExists(webAnnotation.getBody());
        this.validateTranscriptionBodyWithFullTextResource(webAnnotation.getBody(), authentication);
        if (webAnnotation.getTarget() != null) {
            this.validateTargetBaseUrl(webAnnotation.getTarget());
            if (!StringUtils.isBlank((CharSequence)webAnnotation.getTarget().getScope()) && StringUtils.isBlank((CharSequence)webAnnotation.getTarget().getSource())) {
                throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TRANSCRIPTION_TARGET_SOURCE});
            }
        }
    }

    protected void validateSubtitleOrCaption(Annotation webAnnotation, Authentication authentication) throws ParamValidationI18NException, RequestBodyValidationException, PropertyValidationException {
        Body body = webAnnotation.getBody();
        this.validateBodyExists(body);
        this.validateFullTextResource(body);
        this.validateSubtitleBody(body);
        if (webAnnotation.getTarget() != null) {
            this.validateTargetBaseUrl(webAnnotation.getTarget());
            if (!StringUtils.isBlank((CharSequence)webAnnotation.getTarget().getScope()) && StringUtils.isBlank((CharSequence)webAnnotation.getTarget().getSource())) {
                throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TRANSCRIPTION_TARGET_SOURCE});
            }
        }
        this.validateEdmRights(body, authentication);
    }

    protected void validateLinkForContributing(Annotation webAnnotation) throws RequestBodyValidationException, PropertyValidationException {
        this.validateBodyExists(webAnnotation.getBody());
        String bodyUrl = webAnnotation.getBody().getValue();
        if (bodyUrl == null) {
            bodyUrl = webAnnotation.getBody().getHttpUri();
        }
        if (bodyUrl == null || !GeneralUtils.urlStartsWithHttps((String)bodyUrl)) {
            throw new RequestBodyValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"body.id or body.value is mandatory and must use https protocol: ", bodyUrl});
        }
        if (webAnnotation.getTarget() == null) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{TARGET});
        }
        String scope = webAnnotation.getTarget().getScope();
        if (scope != null) {
            throw new RequestBodyValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"target.scope is not allowed for this annotation type: ", scope});
        }
        String source = webAnnotation.getTarget().getSource();
        if (source != null) {
            throw new RequestBodyValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"target.source is not allowed for this annotation type: ", source});
        }
        if (StringUtils.isBlank((CharSequence)webAnnotation.getTarget().getHttpUri())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{"target/target.id"});
        }
        this.validateTargetBaseUrl(webAnnotation.getTarget());
    }

    private void validateSubtitleBody(Body body) throws PropertyValidationException {
        if (StringUtils.isBlank((CharSequence)body.getContentType())) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY_FORMAT});
        }
        if (!this.subtitleHandler.hasSubtitleFormat(body.getContentType())) {
            throw new PropertyValidationException("error.annotation_invalid_subtitles_formats", "error.annotation_invalid_subtitles_formats", new String[]{BODY_FORMAT});
        }
        try {
            this.subtitleHandler.parseSubtitle(body.getValue(), body.getContentType());
        }
        catch (Throwable e) {
            throw new PropertyValidationException("error.annotation_invalid_subtitles_value", "error.annotation_invalid_subtitles_value", new String[]{BODY_VALUE}, e);
        }
    }

    private void validateBodyExists(Body body) throws PropertyValidationException {
        if (body == null) {
            throw new PropertyValidationException("error.message_missing_mandatory_field", "error.message_missing_mandatory_field", new String[]{BODY});
        }
    }

    private void validateTargetBaseUrl(Target target) throws PropertyValidationException {
        if (target.getValue() != null) {
            if (!target.getValue().contains(this.getConfiguration().getAnnoItemDataEndpoint())) {
                throw new PropertyValidationException("error.annotation_target_base_url", "error.annotation_target_base_url", new String[]{this.getConfiguration().getAnnoItemDataEndpoint()});
            }
        } else if (target.getValues() != null) {
            for (String targetValue : target.getValues()) {
                if (targetValue.contains(this.getConfiguration().getAnnoItemDataEndpoint())) continue;
                throw new PropertyValidationException("error.annotation_target_base_url", "error.annotation_target_base_url", new String[]{this.getConfiguration().getAnnoItemDataEndpoint()});
            }
        } else if (target.getScope() != null && !target.getScope().contains(this.getConfiguration().getAnnoItemDataEndpoint())) {
            throw new PropertyValidationException("error.annotation_target_base_url", "error.annotation_target_base_url", new String[]{this.getConfiguration().getAnnoItemDataEndpoint()});
        }
    }
}

