/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.impl;

import eu.europeana.annotation.definitions.exception.WhitelistValidationException;
import eu.europeana.annotation.definitions.model.whitelist.WhitelistEntry;
import eu.europeana.annotation.mongo.service.PersistentWhitelistService;
import eu.europeana.annotation.utils.parse.WhiteListParser;
import eu.europeana.annotation.web.service.WhitelistService;
import eu.europeana.annotation.web.service.impl.BaseAnnotationServiceImpl;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

public class WhitelistServiceImpl
extends BaseAnnotationServiceImpl
implements WhitelistService {
    @Resource(name="annotation_db_whitelistService")
    PersistentWhitelistService mongoWhitelistPersistence;

    public PersistentWhitelistService getMongoWhitelistPersistence() {
        return this.mongoWhitelistPersistence;
    }

    public void setMongoWhitelistPersistance(PersistentWhitelistService mongoWhitelistPersistence) {
        this.mongoWhitelistPersistence = mongoWhitelistPersistence;
    }

    public WhitelistEntry storeWhitelistEntry(WhitelistEntry newWhitelistEntry) throws WhitelistValidationException {
        this.validateWhitelistEntry(newWhitelistEntry);
        return this.getMongoWhitelistPersistence().store(newWhitelistEntry);
    }

    public WhitelistEntry updateWhitelistEntry(WhitelistEntry whitelist) {
        return this.getMongoWhitelistPersistence().update(whitelist);
    }

    public int deleteWhitelistEntry(String url) {
        int res = this.getMongoWhitelistPersistence().removeByUrl(url);
        if (res == 0) {
            throw new WhitelistValidationException("No whitelist entry found for delete. ");
        }
        return res;
    }

    public WhitelistEntry getWhitelistEntryByUrl(String url) {
        return this.getMongoWhitelistPersistence().findByUrl(url);
    }

    public WhitelistEntry getWhitelistEntryByName(String name) {
        return this.getMongoWhitelistPersistence().findByName(name);
    }

    public int deleteWholeWhitelist() {
        int numDeletedWhitelistEntries = this.getMongoWhitelistPersistence().removeAll();
        if (numDeletedWhitelistEntries == 0) {
            throw new WhitelistValidationException("No whitelist entry found for delete. ");
        }
        return numDeletedWhitelistEntries;
    }

    private void validateMandatoryFields(WhitelistEntry whitelistEntry) {
        if (whitelistEntry.getName() == null) {
            throw new WhitelistValidationException("Whitelist name must not be null");
        }
        if (whitelistEntry.getHttpUrl() == null) {
            throw new WhitelistValidationException("Whitelist HTTP uri must not be null");
        }
        if (whitelistEntry.getStatus() == null) {
            throw new WhitelistValidationException("Whitelist status must not be null");
        }
        if (!whitelistEntry.getHttpUrl().startsWith("http")) {
            throw new WhitelistValidationException("Whitelist HTTP uri must start with \"http\"");
        }
    }

    private void enrichWhitelistEntry(WhitelistEntry whitelistEntry) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date dateobj = new Date();
        String currentDateStr = df.format(dateobj);
        try {
            Date currentDate = df.parse(currentDateStr);
            whitelistEntry.setCreationDate(currentDate);
            whitelistEntry.setLastUpdate(currentDate);
            whitelistEntry.setEnableFrom(currentDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public List<? extends WhitelistEntry> loadWhitelistFromResources() throws WhitelistValidationException {
        List res = new ArrayList();
        String whitelistPath = this.getConfiguration().getDefaultWhitelistResourcePath();
        List defaultWhitelist = new ArrayList();
        URL whiteListFile = this.getClass().getResource(whitelistPath);
        defaultWhitelist = WhiteListParser.toWhitelist((String)whiteListFile.getFile());
        for (WhitelistEntry whitelistEntry : defaultWhitelist) {
            this.storeWhitelistEntry(whitelistEntry);
        }
        res = this.getWhitelist();
        return res;
    }

    private void validateWhitelistEntry(WhitelistEntry whitelistEntry) {
        this.validateMandatoryFields(whitelistEntry);
        this.enrichWhitelistEntry(whitelistEntry);
        if (this.getWhitelistEntryByUrl(whitelistEntry.getHttpUrl()) != null) {
            throw new WhitelistValidationException("Whitelist entry for the given URL already exists. " + whitelistEntry.getHttpUrl());
        }
        if (this.getWhitelistEntryByName(whitelistEntry.getName()) != null) {
            throw new WhitelistValidationException("Whitelist entry for the given name already exists. " + whitelistEntry.getHttpUrl());
        }
    }

    public List<? extends WhitelistEntry> getWhitelist() {
        return this.getMongoWhitelistPersistence().getAll();
    }

    protected boolean validateResource(String value) {
        return false;
    }
}

