/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.impl;

import eu.europeana.annotation.config.AnnotationConfiguration;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.moderation.Summary;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.vocabulary.AnnotationStates;
import eu.europeana.annotation.definitions.model.vocabulary.MotivationTypes;
import eu.europeana.annotation.mongo.model.internal.PersistentAnnotation;
import eu.europeana.annotation.mongo.service.PersistentAnnotationService;
import eu.europeana.annotation.mongo.service.PersistentModerationRecordService;
import eu.europeana.annotation.solr.exceptions.AnnotationStateException;
import eu.europeana.annotation.solr.service.SolrAnnotationService;
import eu.europeana.annotation.utils.GeneralUtils;
import eu.europeana.annotation.web.exception.AnnotationIndexingException;
import eu.europeana.annotation.web.exception.authorization.UserAuthorizationException;
import eu.europeana.annotation.web.exception.response.AnnotationNotFoundException;
import eu.europeana.annotation.web.validation.BaseAnnotationValidator;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;

public abstract class BaseAnnotationServiceImpl
extends BaseAnnotationValidator {
    protected static Logger logger = LogManager.getLogger(BaseAnnotationServiceImpl.class);
    @Resource
    AnnotationConfiguration configuration;
    @Autowired
    @Qualifier(value="solrAnnotationService")
    SolrAnnotationService solrAnnotationService;
    @Resource
    PersistentAnnotationService mongoPersistance;
    @Resource(name="annotation_db_moderationRecordService")
    PersistentModerationRecordService mongoModerationRecordPersistance;

    protected AnnotationConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AnnotationConfiguration configuration) {
        this.configuration = configuration;
    }

    protected PersistentAnnotationService getMongoPersistence() {
        return this.mongoPersistance;
    }

    public void setMongoPersistance(PersistentAnnotationService mongoPersistance) {
        this.mongoPersistance = mongoPersistance;
    }

    public PersistentModerationRecordService getMongoModerationRecordPersistence() {
        return this.mongoModerationRecordPersistance;
    }

    public SolrAnnotationService getSolrService() {
        return this.solrAnnotationService;
    }

    public void setSolrService(SolrAnnotationService solrAnnotationService) {
        this.solrAnnotationService = solrAnnotationService;
    }

    public Annotation getAnnotationById(long annoIdentifier, String userId, boolean enabled) throws AnnotationNotFoundException, UserAuthorizationException {
        PersistentAnnotation annotation = this.getMongoPersistence().getByIdentifier(annoIdentifier);
        if (annotation == null) {
            throw new AnnotationNotFoundException(null, "error.annotation_not_found", new String[]{String.valueOf(annoIdentifier)});
        }
        try {
            this.checkPrivacy((Annotation)annotation, userId);
        }
        catch (AnnotationStateException e) {
            throw new UserAuthorizationException(null, "error.annotation_user_not_authorized", new String[]{userId}, (Throwable)e);
        }
        if (enabled) {
            try {
                this.checkVisibility((Annotation)annotation);
            }
            catch (AnnotationStateException e) {
                throw new UserAuthorizationException(null, "error.annotation_not_accessible", new String[]{annotation.getStatus()}, HttpStatus.GONE, (Throwable)e);
            }
        }
        return annotation;
    }

    protected void checkVisibility(Annotation annotation) throws AnnotationStateException {
        if (annotation.isDisabled()) {
            throw new AnnotationStateException("Annotation is not accessible!", AnnotationStates.DISABLED);
        }
    }

    protected void checkPrivacy(Annotation annotation, String user) throws AnnotationStateException {
        if (annotation.isPrivate() && !annotation.getCreator().getHttpUrl().equals(user)) {
            throw new AnnotationStateException("Annotation is not accessible!", AnnotationStates.PRIVATE);
        }
    }

    protected boolean reindexAnnotation(Annotation res, Date lastIndexing) throws AnnotationIndexingException {
        if (!this.getConfiguration().isIndexingEnabled()) {
            this.getLogger().warn("Annotation was not reindexed, indexing is disabled. See configuration properties!");
            return false;
        }
        try {
            Summary summary = this.getMongoModerationRecordPersistence().getModerationSummaryByAnnotationId(res.getIdentifier());
            this.getSolrService().update(res, summary);
            this.updateLastIndexingTime(res, lastIndexing);
            return true;
        }
        catch (Exception e) {
            throw new AnnotationIndexingException("Cannot reindex annotation with the identifier: " + res.getIdentifier(), (Throwable)e);
        }
    }

    public boolean reindexAnnotationById(long annoIdentifier, Date lastIndexing) {
        boolean success = false;
        try {
            PersistentAnnotation annotation = this.getMongoPersistence().getByIdentifier(annoIdentifier);
            success = this.reindexAnnotation((Annotation)annotation, lastIndexing);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return false;
        }
        return success;
    }

    protected void updateLastIndexingTime(Annotation res, Date lastIndexing) {
        try {
            this.getMongoPersistence().updateIndexingTime(res, lastIndexing);
            ((PersistentAnnotation)res).setLastIndexed(lastIndexing);
        }
        catch (Exception e) {
            this.getLogger().warn("The time of the last SOLR indexing could not be saved in the Mongo database. ", (Throwable)e);
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public PersistentAnnotationService getMongoPersistance() {
        return this.mongoPersistance;
    }

    protected Annotation updateAndReindex(PersistentAnnotation persistentAnnotation) {
        PersistentAnnotation res = this.getMongoPersistence().update(persistentAnnotation);
        try {
            this.reindexAnnotation((Annotation)res, res.getLastUpdate());
        }
        catch (AnnotationIndexingException e) {
            this.getLogger().warn("The annotation with the identifier: " + persistentAnnotation.getIdentifier() + " could not be reindexed successfully.", (Throwable)e);
        }
        return res;
    }

    boolean isSemanticTag(Annotation annotation) {
        return MotivationTypes.TAGGING.equals((Object)annotation.getMotivationType()) && this.hasBodyUrl(annotation);
    }

    boolean hasBodyUrl(Annotation annotation) {
        return GeneralUtils.isUrl((String)annotation.getBody().getValue());
    }

    boolean isDereferenceProfile(SearchProfiles searchProfile) {
        return SearchProfiles.DEREFERENCE.equals((Object)searchProfile);
    }
}

