/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.impl;

import eu.europeana.annotation.config.AnnotationConfiguration;
import eu.europeana.annotation.definitions.exception.AnnotationAttributeInstantiationException;
import eu.europeana.annotation.definitions.exception.AnnotationDereferenciationException;
import eu.europeana.annotation.definitions.exception.AnnotationValidationException;
import eu.europeana.annotation.definitions.exception.ModerationRecordValidationException;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.StatusLog;
import eu.europeana.annotation.definitions.model.impl.BaseStatusLog;
import eu.europeana.annotation.definitions.model.moderation.ModerationRecord;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.vocabulary.MotivationTypes;
import eu.europeana.annotation.dereferenciation.MetisDereferenciationClient;
import eu.europeana.annotation.mongo.exception.BulkOperationException;
import eu.europeana.annotation.mongo.exception.ModerationMongoException;
import eu.europeana.annotation.mongo.model.internal.PersistentAnnotation;
import eu.europeana.annotation.mongo.model.internal.PersistentModerationRecord;
import eu.europeana.annotation.mongo.service.PersistentStatusLogService;
import eu.europeana.annotation.mongo.service.PersistentWhitelistService;
import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.solr.exceptions.StatusLogServiceException;
import eu.europeana.annotation.utils.parse.AnnotationLdParser;
import eu.europeana.annotation.web.exception.request.AnnotationUniquenessValidationException;
import eu.europeana.annotation.web.exception.request.ParamValidationI18NException;
import eu.europeana.annotation.web.exception.request.PropertyValidationException;
import eu.europeana.annotation.web.exception.request.RequestBodyValidationException;
import eu.europeana.annotation.web.model.BatchReportable;
import eu.europeana.annotation.web.model.BatchUploadStatus;
import eu.europeana.annotation.web.service.AnnotationDefaults;
import eu.europeana.annotation.web.service.AnnotationService;
import eu.europeana.annotation.web.service.impl.BaseAnnotationServiceImpl;
import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.api.commons.web.exception.HttpException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.stanbol.commons.exception.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="annotationService")
public class AnnotationServiceImpl
extends BaseAnnotationServiceImpl
implements AnnotationService {
    @Resource(name="annotation_db_whitelistService")
    PersistentWhitelistService mongoWhitelistPersistence;
    @Resource(name="annotation_db_statusLogService")
    PersistentStatusLogService mongoStatusLogPersistence;
    @Resource(name="i18nService")
    I18nService i18nService;
    @Autowired
    @Qualifier(value="metisDereferenceClient")
    MetisDereferenciationClient dereferenciationClient;

    public AnnotationConfiguration getConfiguration() {
        return this.configuration;
    }

    public PersistentWhitelistService getMongoWhitelistPersistence() {
        return this.mongoWhitelistPersistence;
    }

    public PersistentStatusLogService getMongoStatusLogPersistence() {
        return this.mongoStatusLogPersistence;
    }

    public List<? extends Annotation> getAnnotationList(List<Long> identifiers) {
        return this.getMongoPersistence().getAnnotationList(identifiers);
    }

    public List<? extends Annotation> getAllAnnotations() {
        return this.getMongoPersistence().getAllAnnotations();
    }

    public List<? extends StatusLog> searchStatusLogs(String query, String startOn, String limit) throws StatusLogServiceException {
        return this.getMongoStatusLogPersistence().getFilteredStatusLogList(query, startOn, limit);
    }

    public Annotation parseAnnotationLd(MotivationTypes motivationType, String annotationJsonLdStr) throws JsonParseException, HttpException {
        try {
            AnnotationLdParser europeanaParser = new AnnotationLdParser();
            return europeanaParser.parseAnnotation(motivationType, annotationJsonLdStr);
        }
        catch (AnnotationAttributeInstantiationException e) {
            throw new RequestBodyValidationException(annotationJsonLdStr, "error.annotation_cant_parse_body", (Throwable)e);
        }
    }

    public Annotation storeAnnotation(Annotation newAnnotation) {
        return this.storeAnnotation(newAnnotation, true);
    }

    public Annotation storeAnnotation(Annotation newAnnotation, boolean indexing) {
        this.validateAnnotationIdentifier(newAnnotation);
        Annotation res = this.getMongoPersistence().store(newAnnotation);
        if (indexing && this.getConfiguration().isIndexingEnabled()) {
            try {
                this.getSolrService().store(res);
            }
            catch (Exception e) {
                this.getLogger().info("The annotation was stored correctly into the Mongo, but it was not indexed yet. ", (Throwable)e);
            }
            this.updateLastIndexingTime(res, newAnnotation.getLastUpdate());
        }
        return res;
    }

    public ModerationRecord storeModerationRecord(ModerationRecord newModerationRecord) {
        this.validateAnnotationIdForModerationRecord(newModerationRecord);
        ModerationRecord res = this.getMongoModerationRecordPersistence().store(newModerationRecord);
        Date lastindexing = res.getLastUpdated();
        if (this.getConfiguration().isIndexingEnabled()) {
            try {
                PersistentAnnotation annotation = this.getMongoPersistance().getByIdentifier(res.getIdentifier());
                this.reindexAnnotation((Annotation)annotation, lastindexing);
            }
            catch (Exception e) {
                this.getLogger().warn("The moderation record was stored correctly into the Mongo, but related annotation was not indexed with summary yet. ", (Throwable)e);
            }
        }
        return res;
    }

    public ModerationRecord findModerationRecordById(long annoIdentifier) throws ModerationMongoException {
        return this.getMongoModerationRecordPersistence().find(annoIdentifier);
    }

    protected void validateAnnotationIdentifier(Annotation newAnnotation) {
        if (newAnnotation.getIdentifier() <= 0L) {
            throw new AnnotationValidationException("Annotaion identifier must be >0!");
        }
    }

    protected void validateAnnotationIdForModerationRecord(ModerationRecord newModerationRecord) {
        if (newModerationRecord.getIdentifier() <= 0L) {
            throw new ModerationRecordValidationException("ModerationRecord identifier must be >0!");
        }
    }

    public Annotation updateAnnotation(PersistentAnnotation persistentAnnotation, Annotation webAnnotation) throws AnnotationServiceException, HttpException {
        this.mergeAnnotationProperties(persistentAnnotation, webAnnotation);
        Set duplicateAnnotationIds = this.checkDuplicateAnnotations((Annotation)persistentAnnotation, true);
        if (!duplicateAnnotationIds.isEmpty()) {
            String[] i18nParamsAnnoDuplicates = new String[]{String.join((CharSequence)",", duplicateAnnotationIds)};
            throw new AnnotationUniquenessValidationException("error.annotation_duplication", "error.annotation_duplication", i18nParamsAnnoDuplicates);
        }
        Annotation res = this.updateAndReindex(persistentAnnotation);
        return res;
    }

    private void mergeAnnotationProperties(PersistentAnnotation annotation, Annotation webAnnotation) {
        if (webAnnotation.getType() != null) {
            annotation.setType(webAnnotation.getType());
        }
        if (webAnnotation.getGenerated() != null) {
            annotation.setGenerated(webAnnotation.getGenerated());
        }
        if (webAnnotation.getBody() != null) {
            annotation.setBody(webAnnotation.getBody());
        }
        if (webAnnotation.getTarget() != null) {
            annotation.setTarget(webAnnotation.getTarget());
        }
        if (annotation.isDisabled() != webAnnotation.isDisabled()) {
            annotation.setDisabled(webAnnotation.getDisabled());
        }
        if (webAnnotation.getEquivalentTo() != null) {
            annotation.setEquivalentTo(webAnnotation.getEquivalentTo());
        }
        if (webAnnotation.getInternalType() != null) {
            annotation.setInternalType(webAnnotation.getInternalType());
        }
        if (webAnnotation.getStatus() != null) {
            annotation.setStatus(webAnnotation.getStatus());
        }
        if (webAnnotation.getStyledBy() != null) {
            annotation.setStyledBy(webAnnotation.getStyledBy());
        }
        this.mergeReferenceFields(annotation, webAnnotation);
        this.mergeOrSetLastUpdate(annotation, webAnnotation);
    }

    private void mergeReferenceFields(PersistentAnnotation annotation, Annotation webAnnotation) {
        if (webAnnotation.getSameAs() != null) {
            annotation.setSameAs(webAnnotation.getSameAs());
        }
        if (webAnnotation.getCanonical() != null && StringUtils.isEmpty((CharSequence)annotation.getCanonical())) {
            annotation.setCanonical(webAnnotation.getCanonical());
        }
        if (webAnnotation.getVia() != null) {
            annotation.setVia(webAnnotation.getVia());
        }
    }

    private void mergeOrSetLastUpdate(PersistentAnnotation annotation, Annotation webAnnotation) {
        if (webAnnotation.getLastUpdate() != null) {
            annotation.setLastUpdate(webAnnotation.getLastUpdate());
        } else {
            Date timeStamp = new Date();
            annotation.setLastUpdate(timeStamp);
        }
    }

    public Annotation updateAnnotationStatus(Annotation annotation) {
        return this.getMongoPersistence().updateStatus(annotation);
    }

    public Annotation disableAnnotation(long annoIdentifier) {
        PersistentAnnotation res = this.getMongoPersistence().getByIdentifier(annoIdentifier);
        return this.disableAnnotation((Annotation)res);
    }

    public Annotation disableAnnotation(Annotation annotation) {
        PersistentAnnotation persistentAnnotation = annotation instanceof PersistentAnnotation ? (PersistentAnnotation)annotation : this.getMongoPersistence().getByIdentifier(annotation.getIdentifier());
        persistentAnnotation.setDisabled(new Date());
        persistentAnnotation = this.getMongoPersistence().update(persistentAnnotation);
        if (this.getConfiguration().isIndexingEnabled()) {
            this.removeFromIndex(annotation);
        }
        return persistentAnnotation;
    }

    public Annotation enableAnnotation(long annoIdentifier) throws AnnotationServiceException {
        PersistentAnnotation persistentAnnotation = this.getMongoPersistence().getByIdentifier(annoIdentifier);
        persistentAnnotation.setDisabled(null);
        persistentAnnotation = this.getMongoPersistence().update(persistentAnnotation);
        if (this.getConfiguration().isIndexingEnabled()) {
            try {
                this.getSolrService().store((Annotation)persistentAnnotation);
            }
            catch (Exception e) {
                this.getLogger().info("The annotation is correctly enabled in the Mongo, but it is not yet indexed in Solr. ", (Throwable)e);
            }
            this.updateLastIndexingTime((Annotation)persistentAnnotation, persistentAnnotation.getLastUpdate());
        }
        return persistentAnnotation;
    }

    protected boolean removeFromIndex(Annotation annotation) {
        try {
            this.getSolrService().delete(annotation.getIdentifier());
        }
        catch (Exception e) {
            this.getLogger().error("Cannot remove annotation from solr index: " + annotation.getIdentifier(), (Throwable)e);
            return false;
        }
        return true;
    }

    public List<? extends Annotation> getAnnotationListByTarget(String target) {
        return this.getMongoPersistence().getAnnotationListByTarget(target);
    }

    public List<? extends Annotation> getAnnotationListByResourceId(String resourceId) {
        return this.getMongoPersistence().getAnnotationListByResourceId(resourceId);
    }

    public boolean existsInDb(long annoIdentifier) {
        boolean res = false;
        try {
            PersistentAnnotation dbRes = this.getMongoPersistence().getByIdentifier(annoIdentifier);
            if (dbRes != null) {
                res = true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public List<? extends Annotation> getExisting(List<Long> annotationIdentifiers) {
        List dbRes = this.getMongoPersistence().getAnnotationList(annotationIdentifiers);
        return dbRes;
    }

    public boolean existsModerationInDb(long annoIdentifier) throws ModerationMongoException {
        boolean res = false;
        PersistentModerationRecord dbRes = this.getMongoModerationRecordPersistence().find(annoIdentifier);
        if (dbRes != null) {
            res = true;
        }
        return res;
    }

    public void logAnnotationStatusUpdate(String user, Annotation annotation) {
        BaseStatusLog statusLog = new BaseStatusLog();
        statusLog.setUser(user);
        statusLog.setStatus(annotation.getStatus());
        long currentTimestamp = System.currentTimeMillis();
        statusLog.setDate(currentTimestamp);
        statusLog.setIdentifier(annotation.getIdentifier());
        this.getMongoStatusLogPersistence().store((StatusLog)statusLog);
    }

    public void validateWebAnnotations(List<? extends Annotation> webAnnotations, BatchReportable batchReportable, Authentication authentication) {
        for (Annotation annotation : webAnnotations) {
            try {
                this.validateWebAnnotation(annotation, authentication);
                batchReportable.incrementSuccessCount();
            }
            catch (ParamValidationI18NException | PropertyValidationException | RequestBodyValidationException e) {
                batchReportable.incrementFailureCount();
                String message = this.i18nService.getMessage(e.getI18nKey(), e.getI18nParams());
                batchReportable.addError(String.valueOf(annotation.getIdentifier()), message);
            }
        }
    }

    public void reportNonExisting(List<? extends Annotation> annotations, BatchReportable batchReportable, List<Long> missingIdentifiers) {
        for (Annotation annotation : annotations) {
            if (missingIdentifiers.contains(annotation.getIdentifier())) {
                batchReportable.incrementFailureCount();
                batchReportable.addError(String.valueOf(annotation.getIdentifier()), "Annotation does not exist: " + annotation.getIdentifier());
                continue;
            }
            batchReportable.incrementSuccessCount();
        }
    }

    public void updateExistingAnnotations(BatchReportable batchReportable, List<? extends Annotation> existingAnnos, List<? extends Annotation> updateAnnos, LinkedHashMap<Annotation, Annotation> webAnnoStoredAnnoAnnoMap) throws AnnotationValidationException, BulkOperationException, IOException, InterruptedException {
        if (existingAnnos.size() != updateAnnos.size()) {
            throw new IllegalArgumentException("The existing and update lists must be of equal size");
        }
        this.getMongoPersistence().createBackupCopy(existingAnnos);
        for (int i = 0; i < existingAnnos.size(); ++i) {
            Annotation existingAnno = existingAnnos.get(i);
            Annotation updateAnno = updateAnnos.stream().filter(anno -> anno.getIdentifier() == existingAnno.getIdentifier()).findAny().orElse(null);
            if (updateAnno == null) continue;
            this.mergeAnnotationProperties((PersistentAnnotation)existingAnno, updateAnno);
            existingAnno.setLastUpdate(new Date());
            webAnnoStoredAnnoAnnoMap.put(updateAnno, existingAnno);
        }
        this.getMongoPersistence().update(existingAnnos);
    }

    public void insertNewAnnotations(BatchUploadStatus uploadStatus, List<? extends Annotation> annotations, AnnotationDefaults annoDefaults, LinkedHashMap<Annotation, Annotation> webAnnoStoredAnnoAnnoMap) throws AnnotationValidationException, BulkOperationException, IOException, InterruptedException {
        int count = annotations.size();
        List annoIdSequence = this.generateAnnotationIdentifiers(count);
        if (annotations.size() != annoIdSequence.size()) {
            throw new IllegalStateException("The list of new annotations and corresponding ids are not of equal size");
        }
        for (int i = 0; i < annotations.size(); ++i) {
            Annotation anno = annotations.get(i);
            anno.setIdentifier(((Long)annoIdSequence.get(i)).longValue());
            annoDefaults.putAnnotationDefaultValues(anno);
            webAnnoStoredAnnoAnnoMap.put(anno, anno);
        }
        this.getMongoPersistence().create(annotations);
    }

    public List<Long> generateAnnotationIdentifiers(int count) {
        List annoIdSequence = this.getMongoPersistence().generateAnnotationIdentifierSequence(Integer.valueOf(count));
        return annoIdSequence;
    }

    public void dereferenceSemanticTags(Annotation annotation, SearchProfiles searchProfile, String language) throws HttpException, AnnotationDereferenciationException {
        if (!this.isDereferenceProfile(searchProfile)) {
            return;
        }
        if (!this.hasBodyUrl(annotation)) {
            return;
        }
        String bodyValue = annotation.getBody().getValue();
        Map dereferencedMap = this.dereferenciationClient.dereferenceOne(bodyValue, language);
        this.setDereferencedBody(annotation, dereferencedMap);
    }

    private void setDereferencedBody(Annotation annotation, Map<String, String> dereferencedMap) {
        String bodyValue = annotation.getBody().getValue();
        if (!dereferencedMap.containsKey(bodyValue)) {
            return;
        }
        String dereferencedJsonLdMapStr = dereferencedMap.get(bodyValue);
        if (StringUtils.isNotBlank((CharSequence)dereferencedJsonLdMapStr)) {
            annotation.getBody().setValue(dereferencedJsonLdMapStr);
            annotation.getBody().setInputString(dereferencedJsonLdMapStr);
        }
    }

    public void dereferenceSemanticTags(List<? extends Annotation> annotations, SearchProfiles searchProfile, String languages) throws AnnotationDereferenciationException, HttpException {
        if (!this.isDereferenceProfile(searchProfile)) {
            return;
        }
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        List entityIds = this.extractEntityUris(annotations);
        if (entityIds.isEmpty()) {
            return;
        }
        Map dereferencedMap = this.dereferenciationClient.dereferenceMany(entityIds, languages);
        for (Annotation annotation : annotations) {
            this.setDereferencedBody(annotation, dereferencedMap);
        }
    }

    private List<String> extractEntityUris(List<? extends Annotation> annotations) {
        ArrayList<String> entityIds = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            if (!this.isSemanticTag(annotation)) continue;
            entityIds.add(annotation.getBody().getValue());
        }
        return entityIds;
    }

    public List<String> getDeletedAnnotationSet(MotivationTypes motivation, Date startDate, Date stopDate, int page, int limit) {
        List res = this.getMongoPersistence().getDisabled(motivation, startDate, stopDate, page, limit);
        return res;
    }

    @Deprecated
    protected boolean validateResource(String url) throws ParamValidationI18NException {
        try {
            String domainName = this.getMongoWhitelistPersistence().getDomainName(url);
            Set domains = this.getMongoWhitelistPersistence().getWhitelistDomains();
            if (!domains.contains(domainName)) {
                throw new ParamValidationI18NException("error.invalid_param_value", "error.invalid_param_value", new String[]{"target.value", url});
            }
        }
        catch (URISyntaxException e) {
            throw new ParamValidationI18NException("Given URL is not valid!", "error.message_url_not_valid", new String[]{"target.value", url});
        }
        return true;
    }

    public Set<String> checkDuplicateAnnotations(Annotation annotation, boolean noSelfCheck) throws AnnotationServiceException {
        return this.getSolrService().checkDuplicateAnnotations(annotation, noSelfCheck);
    }
}

