/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.impl;

import eu.europeana.annotation.config.AnnotationConfiguration;
import eu.europeana.annotation.definitions.model.search.Query;
import eu.europeana.annotation.definitions.model.search.QueryImpl;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.search.result.AnnotationPage;
import eu.europeana.annotation.definitions.model.search.result.ResultSet;
import eu.europeana.annotation.definitions.model.search.result.impl.AnnotationPageImpl;
import eu.europeana.annotation.definitions.model.view.AnnotationView;
import eu.europeana.annotation.mongo.service.PersistentAnnotationService;
import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.solr.service.SolrAnnotationService;
import eu.europeana.annotation.solr.vocabulary.search.QueryFilteringFields;
import eu.europeana.annotation.web.service.AnnotationSearchService;
import eu.europeana.annotation.web.service.SearchServiceUtils;
import eu.europeana.annotation.web.service.impl.AnnotationSearchServiceImpl;
import eu.europeana.api.commons.web.exception.HttpException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnnotationSearchServiceImpl
implements AnnotationSearchService {
    @Resource
    AnnotationConfiguration configuration;
    @Resource(name="solrAnnotationService")
    SolrAnnotationService solrAnnotationService;
    @Resource(name="annotation_db_annotationService")
    PersistentAnnotationService mongoPersistance;
    Logger logger = LogManager.getLogger(this.getClass());

    protected AnnotationConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AnnotationConfiguration configuration) {
        this.configuration = configuration;
    }

    public SolrAnnotationService getSolrService() {
        return this.solrAnnotationService;
    }

    public void setSolrService(SolrAnnotationService solrService) {
        this.solrAnnotationService = solrService;
    }

    protected ResultSet<? extends AnnotationView> searchItems(Query query) throws HttpException {
        try {
            return this.getSolrService().search(query);
        }
        catch (AnnotationServiceException e) {
            throw SearchServiceUtils.convertSearchException((String)query.toString(), (AnnotationServiceException)e);
        }
    }

    public AnnotationPage search(Query query, HttpServletRequest request) throws HttpException {
        boolean isLastPage;
        AnnotationPageImpl protocol = new AnnotationPageImpl(query);
        ResultSet resultSet = this.searchItems(query);
        protocol.setItems(resultSet);
        if (this.isIncludeAnnotationsSearch(query) && resultSet.getResults().size() > 0) {
            ArrayList<Long> annotationIds = new ArrayList<Long>(resultSet.getResults().size());
            for (AnnotationView annotationView : resultSet.getResults()) {
                annotationIds.add(annotationView.getIdentifierAsNumber());
            }
            List annotations = this.mongoPersistance.getAnnotationList(annotationIds);
            protocol.setAnnotations(annotations);
        }
        protocol.setTotalInPage((long)resultSet.getResults().size());
        protocol.setTotalInCollection(resultSet.getResultSize());
        String collectionUrl = this.buildCollectionUrl(query, request);
        protocol.setCollectionUri(collectionUrl);
        int currentPage = query.getPageNr();
        String currentPageUrl = this.buildPageUrl(collectionUrl, currentPage, query.getPageSize());
        protocol.setCurrentPageUri(currentPageUrl);
        if (currentPage > 0) {
            String prevPage = this.buildPageUrl(collectionUrl, currentPage - 1, query.getPageSize());
            protocol.setPrevPageUri(prevPage);
        }
        boolean bl = isLastPage = protocol.getTotalInCollection() <= (long)((currentPage + 1) * query.getPageSize());
        if (!isLastPage) {
            String nextPage = this.buildPageUrl(collectionUrl, currentPage + 1, query.getPageSize());
            protocol.setNextPageUri(nextPage);
        }
        return protocol;
    }

    private boolean isIncludeAnnotationsSearch(Query query) {
        return SearchProfiles.STANDARD.equals((Object)query.getSearchProfile());
    }

    private String buildPageUrl(String collectionUrl, int page, int pageSize) {
        StringBuilder builder = new StringBuilder(collectionUrl);
        builder.append("&").append("page").append("=").append(page);
        builder.append("&").append("pageSize").append("=").append(pageSize);
        return builder.toString();
    }

    private String buildCollectionUrl(Query query, HttpServletRequest request) {
        Object queryString = request.getQueryString();
        queryString = this.removeParam("page", (String)queryString);
        queryString = this.removeParam("pageSize", (String)queryString);
        queryString = this.removeParam("profile", (String)queryString);
        queryString = (String)queryString + "&profile=" + query.getSearchProfile().toString();
        String result = this.configuration.getAnnoApiEndpoint() + "/search?";
        result = result + (String)queryString;
        return result;
    }

    protected String removeParam(String queryParam, String queryParams) {
        Object tmp;
        int startPos = queryParams.indexOf(queryParam + "=");
        int startEndPos = queryParams.indexOf("&", startPos + 1);
        if (startPos >= 0) {
            if (startPos > 0) {
                --startPos;
            }
            tmp = queryParams.substring(0, startPos);
            if (startEndPos > 0) {
                tmp = (String)tmp + queryParams.substring(startEndPos);
            }
        } else {
            tmp = queryParams;
        }
        return tmp;
    }

    public Query buildSearchQuery(String queryString, String[] filters, String[] facets, String sort, String sortOrder, int pageNr, int pageSize, SearchProfiles profile) {
        QueryImpl searchQuery = new QueryImpl();
        searchQuery.setQuery(queryString);
        if (pageNr < 0) {
            searchQuery.setPageNr(0);
        } else {
            searchQuery.setPageNr(pageNr);
        }
        int rows = this.buildRealPageSize(pageSize, profile);
        searchQuery.setPageSize(rows);
        searchQuery.setFacetFields(facets);
        this.translateSearchFilters(filters);
        searchQuery.setFilters(filters);
        searchQuery.setSearchProfile(profile);
        this.setSearchFields((Query)searchQuery, profile);
        if (!StringUtils.isBlank((CharSequence)sort)) {
            searchQuery.setSort(sort);
            searchQuery.setSortOrder(sortOrder);
        }
        return searchQuery;
    }

    protected int buildRealPageSize(int pageSize, SearchProfiles profile) {
        int rows = 0;
        int maxPageSize = this.getConfiguration().getMaxPageSize(profile.toString());
        rows = pageSize < 0 ? 10 : (pageSize > maxPageSize ? maxPageSize : pageSize);
        return rows;
    }

    private void setSearchFields(Query searchQuery, SearchProfiles profile) {
        switch (1.$SwitchMap$eu$europeana$annotation$definitions$model$search$SearchProfiles[profile.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                searchQuery.setViewFields(new String[]{"anno_uri"});
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected void translateSearchFilters(String[] filters) {
        if (filters != null) {
            int count = 0;
            int FILTER_MODEL_POS = 0;
            int FILTER_VALUE_POS = 1;
            for (String filter : filters) {
                String[] filterElem;
                if (filter.contains(":") && QueryFilteringFields.contains((String)(filterElem = filter.split(":"))[FILTER_MODEL_POS])) {
                    filters[count] = QueryFilteringFields.getSolrFieldByModel((String)filterElem[FILTER_MODEL_POS]) + ":" + filterElem[FILTER_VALUE_POS];
                }
                ++count;
            }
        }
    }
}

