/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.impl;

import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.target.Target;
import eu.europeana.annotation.definitions.model.utils.TypeUtils;
import eu.europeana.annotation.mongo.exception.AnnotationMongoException;
import eu.europeana.annotation.mongo.model.internal.PersistentAnnotation;
import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.web.exception.IndexingJobLockedException;
import eu.europeana.annotation.web.exception.response.AnnotationNotFoundException;
import eu.europeana.annotation.web.model.BatchProcessingStatus;
import eu.europeana.annotation.web.service.AdminService;
import eu.europeana.annotation.web.service.impl.BaseAnnotationServiceImpl;
import eu.europeana.api.commons.definitions.exception.ApiWriteLockException;
import eu.europeana.api.commons.nosql.entity.ApiWriteLock;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class AdminServiceImpl
extends BaseAnnotationServiceImpl
implements AdminService {
    @Resource(name="annotation_db_apilockService")
    ApiWriteLockService apiWriteLockService;

    public BatchProcessingStatus deleteAnnotationSet(List<Long> identifiers) {
        BatchProcessingStatus status = new BatchProcessingStatus();
        for (Long identifier : identifiers) {
            try {
                this.deleteAnnotation(identifier.longValue());
                status.incrementSuccessCount();
            }
            catch (Throwable th) {
                this.getLogger().info((Object)th);
                status.incrementFailureCount();
            }
        }
        return status;
    }

    public void deleteAnnotation(long annoIdentifier) throws InternalServerException, AnnotationServiceException {
        this.getSolrService().delete(annoIdentifier);
        try {
            this.getMongoModerationRecordPersistence().remove(annoIdentifier);
        }
        catch (Throwable th) {
            this.getLogger().warn("Cannot remove moderation record for annotation id: " + annoIdentifier);
        }
        try {
            this.getMongoPersistence().remove(annoIdentifier);
        }
        catch (AnnotationMongoException e) {
            if (StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"No annotation found in database for annotation Id! ")) {
                this.getLogger().warn("The annotation with the given Id doesn't exist anymore: " + annoIdentifier);
            }
            throw new AnnotationServiceException("Cannot delete annotation from storage. " + annoIdentifier, (Throwable)e);
        }
        catch (Throwable th) {
            throw new InternalServerException(th);
        }
    }

    public BatchProcessingStatus reindexAnnotationSelection(String startDate, String endDate, String startTimestamp, String endTimestamp, String action) throws HttpException, ApiWriteLockException {
        if (!StringUtils.isBlank((CharSequence)startDate)) {
            startTimestamp = TypeUtils.getUnixDateStringFromDate((String)startDate);
        }
        if (!StringUtils.isBlank((CharSequence)endDate)) {
            endTimestamp = TypeUtils.getUnixDateStringFromDate((String)endDate);
        }
        return this.reindexAnnotationSelection(startTimestamp, endTimestamp, action);
    }

    protected BatchProcessingStatus reindexAnnotationSelection(String startTimestamp, String endTimestamp, String action) throws HttpException {
        List res = this.getMongoPersistence().filterByLastUpdateTimestamp(startTimestamp, endTimestamp);
        try {
            return this.reindexAnnotationSet(res, action);
        }
        catch (ApiWriteLockException e) {
            throw new InternalServerException("Cannot reindex annotation selection", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchProcessingStatus reindexAnnotationSet(List<Long> identifiers, String action) throws HttpException, ApiWriteLockException {
        if (this.apiWriteLockService.getLastActiveLock("reindex") != null) {
            throw new IndexingJobLockedException(action);
        }
        ApiWriteLock apriWriteLock = null;
        try {
            apriWriteLock = this.apiWriteLockService.lock(action);
            AdminServiceImpl adminServiceImpl = this;
            synchronized (adminServiceImpl) {
                BatchProcessingStatus status = new BatchProcessingStatus();
                int count = 0;
                for (Long id : identifiers) {
                    String msg;
                    try {
                        PersistentAnnotation annotation;
                        if (++count % 1000 == 0) {
                            this.getLogger().info("Processing object: {}", (Object)count);
                        }
                        if ((annotation = this.getMongoPersistence().getByIdentifier(id.longValue())) == null) {
                            throw new AnnotationNotFoundException(null, "error.annotation_not_found", new String[]{String.valueOf(id)});
                        }
                        boolean success = this.reindexAnnotationById(id.longValue(), new Date());
                        if (success) {
                            status.incrementSuccessCount();
                            continue;
                        }
                        status.incrementFailureCount();
                        status.addError(String.valueOf(id), "see error log");
                    }
                    catch (IllegalArgumentException iae) {
                        msg = "id: " + id + ". " + iae.getMessage();
                        this.getLogger().error(msg);
                        status.incrementFailureCount();
                        status.addError(String.valueOf(id), msg);
                    }
                    catch (Throwable e) {
                        msg = "Error when reindexing annotation: " + id + e.getMessage();
                        this.getLogger().error(msg);
                        status.incrementFailureCount();
                        status.addError(String.valueOf(id), msg);
                    }
                }
                BatchProcessingStatus batchProcessingStatus = status;
                return batchProcessingStatus;
            }
        }
        finally {
            this.apiWriteLockService.unlock(apriWriteLock);
        }
    }

    public BatchProcessingStatus reindexAll() throws HttpException, ApiWriteLockException {
        return this.reindexAnnotationSelection("0", "" + System.currentTimeMillis(), "reindexAll");
    }

    public BatchProcessingStatus reindexOutdated() throws HttpException, ApiWriteLockException {
        List res = this.getMongoPersistence().filterByLastUpdateGreaterThanLastIndexTimestamp();
        return this.reindexAnnotationSet(res, "reindexOutdated");
    }

    public BatchProcessingStatus updateRecordId(String oldId, String newId) {
        BatchProcessingStatus status = new BatchProcessingStatus();
        List annotations = this.getMongoPersistence().getAnnotationListByResourceId(oldId);
        for (Annotation anno : annotations) {
            if (anno.isDisabled()) continue;
            Target annoTarget = anno.getTarget();
            if (annoTarget.getResourceIds() != null) {
                List currentResourceIds = annoTarget.getResourceIds();
                ArrayList<String> updatedResourceIds = new ArrayList<String>();
                for (String id : currentResourceIds) {
                    if (id.equals(oldId)) {
                        String updatedId = newId;
                        updatedResourceIds.add(updatedId);
                        continue;
                    }
                    updatedResourceIds.add(id);
                }
                annoTarget.setResourceIds(updatedResourceIds);
            }
            if (annoTarget.getHttpUri() != null) {
                String newHttpUri = annoTarget.getHttpUri().replace(oldId, newId);
                annoTarget.setHttpUri(newHttpUri);
            }
            if (annoTarget.getValue() != null) {
                String newValue = annoTarget.getValue().replace(oldId, newId);
                annoTarget.setValue(newValue);
                annoTarget.setInputString(newValue);
            }
            if (annoTarget.getValues() != null && !annoTarget.getValues().isEmpty()) {
                List currentValues = annoTarget.getValues();
                ArrayList<String> updatedValues = new ArrayList<String>();
                for (String value : currentValues) {
                    String updatedValue = value.replace(oldId, newId);
                    updatedValues.add(updatedValue);
                }
                annoTarget.setValues(updatedValues);
                annoTarget.setInputString(((Object)updatedValues).toString());
            }
            anno.setTarget(annoTarget);
            try {
                PersistentAnnotation storedAnno = (PersistentAnnotation)this.updateAndReindex((PersistentAnnotation)anno);
                if (this.isIndexInSync(storedAnno)) {
                    status.incrementSuccessCount();
                    continue;
                }
                status.incrementIndexingFailureCount();
            }
            catch (Exception e) {
                status.incrementFailureCount();
                throw e;
            }
        }
        return status;
    }

    protected boolean isIndexInSync(PersistentAnnotation storedAnno) {
        return storedAnno.getLastIndexed() != null && !storedAnno.getLastIndexed().before(storedAnno.getLastUpdate());
    }

    protected boolean validateResource(String value) {
        return false;
    }
}

