/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.jsonld;

import eu.europeana.annotation.definitions.model.search.Query;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.search.result.AnnotationPage;
import eu.europeana.annotation.solr.vocabulary.search.SortFields;
import eu.europeana.annotation.solr.vocabulary.search.SortOrder;
import eu.europeana.annotation.utils.GeneralUtils;
import eu.europeana.annotation.utils.serialize.AnnotationPageSerializer;
import eu.europeana.annotation.web.exception.request.ParamValidationI18NException;
import eu.europeana.annotation.web.service.controller.BaseRest;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import eu.europeana.api.commons.web.exception.ParamValidationException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Web Annotation Search"}, description=" ")
public class WebAnnotationSearchRest
extends BaseRest {
    private static Logger logger = LogManager.getRootLogger();

    @RequestMapping(value={"/annotation/search", "/annotation/search.json", "/annotation/search.jsonld"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="The following fields are available for search: motivation, anno_uri, anno_id, generator_uri, generator_name, generated, creator_uri, creator_name, created, modified, moderation_score, text, body_value, body_value.&lt;lang&gt;, body_uri, target_uri, target_record_id, link_resource_uri, link_relation. Default is text (i.e. no field specified in search query), urls and ids are keywords and need to be submitted in quotes (e.g. target_record_ids:\"/123/xyz\"). The following profiles are available for search: facet, standard. Sorting is available for fields: motivation, anno_uri, anno_id, generator_uri, generator_name, generated, creator_uri, creator_name, created, modified, moderation_score,  body_value, body_value.&lt;lang&gt;, body_uri, link_resource_uri, link_relation Facets are available for the fields: motivation, generator_uri, generator_name, creator_uri, creator_name, moderation_score, body_value, body_uri, target_uri, target_record_id, link_resource_uri, link_relation", value="Search annotations for the given text query. By default the search will return all annotation fields. The facet param refers to a list of fields the facets is calculated upon. The filters and lang params are used to reduce the amount of data included in the response. ", nickname="search", response=Void.class)
    public ResponseEntity<String> search(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="query") String query, @RequestParam(value="qf", required=false) String[] filters, @RequestParam(value="facet", required=false) String[] facets, @RequestParam(value="sort", required=false) SortFields sort, @RequestParam(value="sortOrder", required=false) SortOrder sortOrder, @RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="language", required=false) String language, HttpServletRequest request) throws HttpException {
        this.verifyReadAccess(request);
        return this.searchAnnotation(wskey, query, filters, facets, sort, sortOrder, page, pageSize, profile, request, language);
    }

    private ResponseEntity<String> searchAnnotation(String wskey, String queryString, String[] filters, String[] facets, SortFields sortField, SortOrder sortOrder, int page, int pageSize, String profile, HttpServletRequest request, String language) throws HttpException {
        try {
            SearchProfiles searchProfile;
            queryString = queryString.trim();
            if (StringUtils.isBlank((CharSequence)queryString)) {
                throw new ParamValidationI18NException("Invalid request. Parameter value must not be null or empty!", "error.annotation_validation", new String[]{"query", queryString});
            }
            SearchProfiles querySearchProfile = searchProfile = this.getProfile(profile, request);
            if (SearchProfiles.DEREFERENCE.equals((Object)searchProfile)) {
                querySearchProfile = SearchProfiles.STANDARD;
            }
            if (!StringUtils.contains((CharSequence)profile, (CharSequence)SearchProfiles.FACETS.toString())) {
                facets = null;
            }
            String sortFieldStr = null;
            if (sortField != null) {
                sortFieldStr = sortField.getSolrField();
            }
            String sortOrderField = null;
            if (sortFieldStr != null) {
                sortOrderField = SortOrder.desc.name();
            }
            if (sortOrder != null) {
                sortOrderField = sortOrder.toString();
            }
            Query searchQuery = this.getAnnotationSearchService().buildSearchQuery(queryString, filters, facets, sortFieldStr, sortOrderField, page, pageSize, querySearchProfile);
            AnnotationPage annotationPage = this.getAnnotationSearchService().search(searchQuery, request);
            if (annotationPage.getAnnotations() != null && SearchProfiles.DEREFERENCE.equals((Object)searchProfile)) {
                this.getAnnotationService().dereferenceSemanticTags(annotationPage.getAnnotations(), SearchProfiles.DEREFERENCE, language);
            }
            AnnotationPageSerializer serializer = new AnnotationPageSerializer(annotationPage, this.getConfiguration().getAnnotationBaseUrl());
            String jsonLd = serializer.serialize(querySearchProfile);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept, Prefer");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/TR/annotation-protocol/constraints>; rel=\"http://www.w3.org/ns/ldp#constrainedBy\"");
            headers.add((Object)"Allow", (Object)"GET");
            headers.add((Object)"Content-Type", (Object)"application/ld+json;charset=utf-8; profile=\"http://www.w3.org/ns/anno.jsonld\"");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private void validateProfiles(List<String> profiles) throws HttpException {
        if (profiles.contains(SearchProfiles.MINIMAL.toString()) && profiles.contains(SearchProfiles.STANDARD.toString()) || profiles.contains(SearchProfiles.MINIMAL.toString()) && profiles.contains(SearchProfiles.DEREFERENCE.toString()) || profiles.contains(SearchProfiles.STANDARD.toString()) && profiles.contains(SearchProfiles.DEREFERENCE.toString())) {
            throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"These profiles are not supported together ", StringUtils.join(profiles, (String)",")});
        }
        for (String profile : profiles) {
            if (SearchProfiles.contains((String)profile)) continue;
            throw new ParamValidationI18NException("error.invalid_param_value", "error.invalid_param_value", new String[]{"profile", profile});
        }
    }

    private SearchProfiles getProfile(String profile, HttpServletRequest request) throws HttpException {
        List allProfiles = GeneralUtils.splitStringIntoList((String)profile, (String)",");
        this.validateProfiles(allProfiles);
        allProfiles.remove(SearchProfiles.FACETS.toString());
        allProfiles.remove(SearchProfiles.DEBUG.toString());
        if (!allProfiles.isEmpty()) {
            return SearchProfiles.getByStr((String)((String)allProfiles.get(0)));
        }
        String preferHeader = request.getHeader("Prefer");
        if (preferHeader != null) {
            if ((preferHeader = preferHeader.replaceAll("\\s+", "")).equals("return=representation;include=\"http://www.w3.org/ns/oa#PreferContainedIRIs\"")) {
                return SearchProfiles.MINIMAL;
            }
            if (preferHeader.equals("return=representation;include=\"http://www.w3.org/ns/oa#PreferContainedDescriptions\"")) {
                return SearchProfiles.STANDARD;
            }
        }
        logger.trace("STANDARD Profile set by default");
        return SearchProfiles.STANDARD;
    }
}

