/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.jsonld;

import eu.europeana.annotation.web.service.controller.jsonld.BaseJsonldRest;
import eu.europeana.api.commons.exception.ApiKeyExtractionException;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.web.exception.HttpException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Web Annotation Protocol"}, description=" ")
public class WebAnnotationProtocolRest
extends BaseJsonldRest {
    @RequestMapping(value={"/annotation/"}, method={RequestMethod.POST}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please find JSON samples for annotation in <a href=\"/annotation_templates.html\" target=\"_blank\">templates</a>.", value="Create annotation", nickname="createAnnotation", response=Void.class)
    public ResponseEntity<String> createAnnotation(@RequestParam(value="indexOnCreate", required=false, defaultValue="true") boolean indexOnCreate, @RequestBody String annotation, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        Authentication authentication = this.verifyWriteAccess("create", request);
        return this.storeAnnotation(null, indexOnCreate, annotation, authentication);
    }

    @RequestMapping(value={"/annotation/{identifier}", "/annotation/{identifier}.jsonld"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(value="Retrieve annotation", nickname="getAnnotation", response=Void.class)
    public ResponseEntity<String> getAnnotation(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="language", required=false) String language, @PathVariable(value="identifier") long identifier, HttpServletRequest request) throws HttpException {
        this.verifyReadAccess(request);
        return this.getAnnotationById(identifier, profile, language);
    }

    @RequestMapping(value={"/annotation/{identifier}"}, method={RequestMethod.PUT}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please find JSON samples for annotation in <a href=\"/annotation_templates.html\" target=\"_blank\">templates</a>. Please create your JSON update request using selected fields you are going to update. E.g. 'body' and 'target' example:   { \"body\": \"Buccin Trombone\",\"target\": \"http://data.europeana.eu/item/09102/_UEDIN_214\" }", value="Update annotation", nickname="updateAnnotation", response=Void.class)
    public ResponseEntity<String> updateAnnotation(@PathVariable(value="identifier") long identifier, @RequestBody String annotation, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.updateAnnotation(identifier, annotation, authentication, request);
    }

    @RequestMapping(value={"/annotation/{identifier}"}, method={RequestMethod.DELETE}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(value="Delete annotation", nickname="deleteAnnotation", response=Void.class)
    public ResponseEntity<String> deleteAnnotation(@PathVariable(value="identifier") long identifier, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        Authentication authentication = this.verifyWriteAccess("delete", request);
        return this.deleteAnnotation(identifier, authentication, request);
    }

    @RequestMapping(value={"/annotation/{identifier}"}, method={RequestMethod.POST}, consumes={"text/plain"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(value="Enable annotation", nickname="enableAnnotation", response=Void.class)
    public ResponseEntity<String> enableAnnotation(@PathVariable(value="identifier") long identifier, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        Authentication authentication = this.verifyWriteAccess("update", request);
        return this.enableAnnotation(identifier, authentication, request);
    }
}

