/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.jsonld;

import eu.europeana.annotation.web.service.controller.jsonld.BaseJsonldRest;
import eu.europeana.api.commons.exception.ApiKeyExtractionException;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.web.exception.HttpException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Provide Feedback on Annotations"}, description=" ")
public class WebAnnotationFeedbackRest
extends BaseJsonldRest {
    @RequestMapping(value={"/annotation/{identifier}/report"}, method={RequestMethod.POST}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(value="Report an (innapropriate) annotation", nickname="reportAnnotation", response=Void.class)
    public ResponseEntity<String> reportAnnotation(@PathVariable(value="identifier") long identifier, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        Authentication authentication = this.verifyWriteAccess("create", request);
        return this.storeAnnotationReport(identifier, authentication);
    }

    @RequestMapping(value={"/annotation/{identifier}/moderationsummary"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(value="Retrieve moderation summary", nickname="getModerationReportSummary", response=Void.class)
    public ResponseEntity<String> getModerationSummary(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="identifier") long identifier, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        this.verifyReadAccess(request);
        return this.getModerationReportSummary(wskey, identifier);
    }
}

