/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.jsonld;

import eu.europeana.annotation.definitions.model.vocabulary.MotivationTypes;
import eu.europeana.annotation.web.service.controller.WebUtils;
import eu.europeana.annotation.web.service.controller.jsonld.BaseJsonldRest;
import eu.europeana.api.commons.definitions.exception.DateParsingException;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.api.commons.exception.ApiKeyExtractionException;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.web.exception.HttpException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Web Annotation Auxiliary Methods"}, description=" ")
public class WebAnnotationAuxiliaryMethodsRest
extends BaseJsonldRest {
    @RequestMapping(value={"/annotations/"}, method={RequestMethod.POST}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please find JSON samples for annotation in <a href=\"/annotation_templates.html\" target=\"_blank\">templates</a>.", value="Create annotations", nickname="createAnnotations", response=Void.class)
    public ResponseEntity<String> createAnnotations(@RequestBody String annotationPage, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        Authentication authentication = this.verifyWriteAccess("create", request);
        return this.storeAnnotations(annotationPage, authentication);
    }

    @RequestMapping(value={"/annotation/{annoType}", "/annotation/{annoType}.jsonld"}, method={RequestMethod.POST}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    @ApiOperation(notes="Please find JSON samples for annotation in <a href=\"/annotation_templates.html\" target=\"_blank\">templates</a>.", value="Create annotation of given type", nickname="createAnnotationByType", response=Void.class)
    public ResponseEntity<String> createAnnotationByTypeJsonld(@RequestParam(value="indexOnCreate", required=false, defaultValue="true") boolean indexOnCreate, @RequestBody String annotation, @PathVariable(value="annoType") String annoType, HttpServletRequest request) throws HttpException {
        Authentication authentication = this.verifyWriteAccess("create", request);
        MotivationTypes motivation = MotivationTypes.getTypeForAnnoType((String)annoType);
        if (motivation == null) {
            throw new HttpException("Invalid parameter value.", "error.invalid_param_value", new String[]{"annoType", annoType}, HttpStatus.BAD_REQUEST);
        }
        return this.storeAnnotation(motivation, indexOnCreate, annotation, authentication);
    }

    @RequestMapping(value={"/annotations/deleted"}, method={RequestMethod.GET})
    @ApiOperation(value="Get ids of deleted Annotations", nickname="getDeleted", response=Void.class, notes="The from and to parameters should have the format yyyy-mm-dd'T'hh:mm:ss'Z', e.g. 1970-01-01T00:00:00Z.")
    public ResponseEntity<String> getDeleted(@RequestParam(value="wskey", required=false) String apiKey, @RequestParam(value="motivation", required=false) String motivation, @RequestParam(value="from", required=false) String startDateStr, @RequestParam(value="to", required=false) String stopDateStr, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="limit", required=false, defaultValue="100") int limit, HttpServletRequest request) throws HttpException {
        this.verifyReadAccess(request);
        MotivationTypes motivationType = this.validateMotivation(motivation);
        Date startDate = null;
        try {
            startDate = startDateStr == null ? DateUtils.parseToDate((String)"1970-01-01T00:00:00Z") : DateUtils.parseToDate((String)startDateStr);
        }
        catch (DateParsingException e) {
            throw new HttpException("Invalid parameter value.", "error.invalid_param_value", new String[]{"from", startDateStr}, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        Date stopDate = null;
        try {
            stopDate = stopDateStr == null ? new Date() : DateUtils.parseToDate((String)stopDateStr);
        }
        catch (DateParsingException e) {
            throw new HttpException("Invalid parameter value.", "error.invalid_param_value", new String[]{"to", stopDateStr}, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        if (startDate.compareTo(stopDate) >= 0) {
            throw new HttpException("The start date (from) needs to be before the stop date (to).", "error.invalid_param_value", new String[]{"from / to ", " " + startDateStr + " / " + stopDateStr}, HttpStatus.BAD_REQUEST);
        }
        List deletions = this.getAnnotationService().getDeletedAnnotationSet(motivationType, startDate, stopDate, page, limit);
        String jsonStr = WebUtils.toJson((Object)deletions);
        LinkedMultiValueMap headers = new LinkedMultiValueMap(1);
        headers.add((Object)"Allow", (Object)"GET");
        ResponseEntity response = new ResponseEntity((Object)jsonStr, (MultiValueMap)headers, HttpStatus.OK);
        return response;
    }

    protected MotivationTypes validateMotivation(String motivation) throws HttpException {
        MotivationTypes motivationType = null;
        if (StringUtils.isNotBlank((CharSequence)motivation) && (motivationType = MotivationTypes.getType((String)motivation)) == MotivationTypes.UNKNOWN) {
            throw new HttpException("Invalid parameter value.", "error.invalid_param_value", new String[]{"motivation", motivation}, HttpStatus.BAD_REQUEST);
        }
        return motivationType;
    }
}

