/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.jsonld;

import com.google.gson.Gson;
import eu.europeana.annotation.definitions.exception.AnnotationAttributeInstantiationException;
import eu.europeana.annotation.definitions.exception.AnnotationInstantiationException;
import eu.europeana.annotation.definitions.exception.AnnotationValidationException;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.agent.Agent;
import eu.europeana.annotation.definitions.model.factory.impl.AgentObjectFactory;
import eu.europeana.annotation.definitions.model.moderation.ModerationRecord;
import eu.europeana.annotation.definitions.model.moderation.Summary;
import eu.europeana.annotation.definitions.model.moderation.Vote;
import eu.europeana.annotation.definitions.model.moderation.impl.BaseModerationRecord;
import eu.europeana.annotation.definitions.model.moderation.impl.BaseSummary;
import eu.europeana.annotation.definitions.model.moderation.impl.BaseVote;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.search.result.AnnotationPage;
import eu.europeana.annotation.definitions.model.search.result.impl.AnnotationPageImpl;
import eu.europeana.annotation.definitions.model.utils.AnnotationIdHelper;
import eu.europeana.annotation.definitions.model.utils.AnnotationsList;
import eu.europeana.annotation.definitions.model.vocabulary.AgentTypes;
import eu.europeana.annotation.definitions.model.vocabulary.MotivationTypes;
import eu.europeana.annotation.mongo.model.internal.PersistentAnnotation;
import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.utils.parse.AnnotationPageParser;
import eu.europeana.annotation.utils.serialize.AnnotationLdSerializer;
import eu.europeana.annotation.utils.serialize.AnnotationPageSerializer;
import eu.europeana.annotation.web.exception.authorization.OperationAuthorizationException;
import eu.europeana.annotation.web.exception.request.AnnotationUniquenessValidationException;
import eu.europeana.annotation.web.exception.request.ParamValidationI18NException;
import eu.europeana.annotation.web.exception.request.RequestBodyValidationException;
import eu.europeana.annotation.web.exception.response.BatchUploadException;
import eu.europeana.annotation.web.model.BatchOperationStep;
import eu.europeana.annotation.web.model.BatchReportable;
import eu.europeana.annotation.web.model.BatchUploadStatus;
import eu.europeana.annotation.web.model.vocabulary.UserRoles;
import eu.europeana.annotation.web.service.AnnotationDefaults;
import eu.europeana.annotation.web.service.SearchServiceUtils;
import eu.europeana.annotation.web.service.authorization.AnnotationAuthorizationUtils;
import eu.europeana.annotation.web.service.controller.BaseRest;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaApiCredentials;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.stanbol.commons.exception.JsonParseException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class BaseJsonldRest
extends BaseRest {
    protected ResponseEntity<String> storeAnnotation(MotivationTypes motivation, boolean indexOnCreate, String annotation, Authentication authentication) throws HttpException {
        Annotation webAnnotation = null;
        try {
            webAnnotation = this.getAnnotationService().parseAnnotationLd(motivation, annotation);
            String userId = authentication.getPrincipal().toString();
            String clientId = ((EuropeanaApiCredentials)authentication.getCredentials()).getClientId();
            String generatorId = AnnotationIdHelper.buildGeneratorUri((String)this.getConfiguration().getAnnoClientApiEndpoint(), (String)clientId);
            String creatorId = AnnotationIdHelper.buildCreatorUri((String)this.getConfiguration().getAnnoUserDataEndpoint(), (String)userId);
            webAnnotation.setGenerator(this.buildAgent(generatorId, AgentTypes.SOFTWARE));
            webAnnotation.setCreator(this.buildAgent(creatorId, AgentTypes.PERSON));
            if (webAnnotation.getIdentifier() != 0L) {
                throw new ParamValidationI18NException("The annotation identifier cannot be provided in the input upon the anntation creation!", "error.annotation_validation", new String[]{"identifier", String.valueOf(webAnnotation.getIdentifier())});
            }
            this.getAnnotationService().validateWebAnnotation(webAnnotation, authentication);
            Set duplicateAnnotationIds = this.getAnnotationService().checkDuplicateAnnotations(webAnnotation, false);
            if (!duplicateAnnotationIds.isEmpty()) {
                String[] i18nParamsAnnoDuplicates = new String[]{String.join((CharSequence)",", duplicateAnnotationIds)};
                throw new AnnotationUniquenessValidationException("error.annotation_duplication", "error.annotation_duplication", i18nParamsAnnoDuplicates);
            }
            long annoIdentifier = this.mongoPersistance.generateAnnotationIdentifier();
            webAnnotation.setIdentifier(annoIdentifier);
            Annotation storedAnnotation = this.getAnnotationService().storeAnnotation(webAnnotation, indexOnCreate);
            AnnotationLdSerializer annotationLd = new AnnotationLdSerializer(storedAnnotation, this.getConfiguration().getAnnotationBaseUrl());
            String jsonLd = annotationLd.toString(4);
            String eTag = this.generateETag(storedAnnotation.getGenerated(), "jsonld", this.buildInfo.getVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"ETag", (Object)eTag);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"POST");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.CREATED);
            return response;
        }
        catch (JsonParseException e) {
            throw new RequestBodyValidationException(annotation, "error.annotation_cant_parse_body", (Throwable)e);
        }
        catch (AnnotationValidationException e) {
            throw new RequestBodyValidationException(annotation, "error.annotation_cant_parse_body", (Throwable)e);
        }
        catch (AnnotationAttributeInstantiationException e) {
            throw new RequestBodyValidationException(annotation, "error.annotation_cant_parse_body", (Throwable)e);
        }
        catch (AnnotationInstantiationException e) {
            throw new HttpException(null, "error.annotation_invalid_body", null, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (AnnotationServiceException e) {
            String debugInfo = webAnnotation != null ? webAnnotation.toString() : "";
            throw SearchServiceUtils.convertSearchException((String)debugInfo, (AnnotationServiceException)e);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected ResponseEntity<String> storeAnnotations(String annotationPageIn, Authentication authentication) throws HttpException {
        try {
            String userId = authentication.getPrincipal().toString();
            AnnotationPageParser annoPageParser = new AnnotationPageParser();
            AnnotationPage annotationPage = annoPageParser.parseAnnotationPage(annotationPageIn);
            List annotations = annotationPage.getAnnotations();
            BatchUploadStatus uploadStatus = new BatchUploadStatus();
            uploadStatus.setTotalNumberOfAnnotations(Integer.valueOf(annotations.size()));
            uploadStatus.setStep(BatchOperationStep.VALIDATION);
            this.getAnnotationService().validateWebAnnotations(annotations, (BatchReportable)uploadStatus, authentication);
            if (uploadStatus.getFailureCount() > 0) {
                throw new BatchUploadException(uploadStatus.toString(), uploadStatus);
            }
            AnnotationsList webAnnotations = new AnnotationsList(annotationPage.getAnnotations());
            AnnotationsList annosWithId = webAnnotations.getAnnotationsWithId();
            uploadStatus.setNumberOfAnnotationsWithId(Integer.valueOf(annosWithId.size()));
            List annoIdentifiers = annosWithId.getIdentifiers();
            AnnotationsList existingInDb = !annoIdentifiers.isEmpty() ? new AnnotationsList(this.getAnnotationService().getExisting(annoIdentifiers)) : new AnnotationsList(new ArrayList(0));
            uploadStatus.setStep(BatchOperationStep.CHECK_UPDATE_ANNOTATIONS_AVAILABLE);
            if (annosWithId.size() != existingInDb.size()) {
                annoIdentifiers.removeAll(existingInDb.getIdentifiers());
                this.getAnnotationService().reportNonExisting(annotations, (BatchReportable)uploadStatus, annoIdentifiers);
                throw new BatchUploadException(uploadStatus.toString(), uploadStatus, HttpStatus.NOT_FOUND);
            }
            LinkedHashMap webAnnoStoredAnnoAnnoMap = webAnnotations.getAnnotationsMap();
            if (annosWithId.getAnnotations().size() > 0) {
                uploadStatus.setStep(BatchOperationStep.UPDATE_EXISTING_ANNOTATIONS);
                this.getAnnotationService().updateExistingAnnotations((BatchReportable)uploadStatus, existingInDb.getAnnotations(), annosWithId.getAnnotations(), webAnnoStoredAnnoAnnoMap);
            }
            AnnotationsList annosWithoutId = webAnnotations.getAnnotationsWithoutId();
            uploadStatus.setStep(BatchOperationStep.INSERT_NEW_ANNOTATIONS);
            uploadStatus.setNumberOfAnnotationsWithoutId(Integer.valueOf(annosWithoutId.size()));
            if (annosWithoutId.size() > 0) {
                String clientId = ((EuropeanaApiCredentials)authentication.getCredentials()).getClientId();
                String generatorId = AnnotationIdHelper.buildGeneratorUri((String)this.getConfiguration().getAnnoClientApiEndpoint(), (String)clientId);
                String creatorId = AnnotationIdHelper.buildCreatorUri((String)this.getConfiguration().getAnnoUserDataEndpoint(), (String)userId);
                AnnotationDefaults annoDefaults = new AnnotationDefaults.Builder().setGenerator(this.buildAgent(generatorId, AgentTypes.SOFTWARE)).setUser(this.buildAgent(creatorId, AgentTypes.PERSON)).build();
                this.getAnnotationService().insertNewAnnotations(uploadStatus, annosWithoutId.getAnnotations(), annoDefaults, webAnnoStoredAnnoAnnoMap);
            }
            AnnotationPageImpl apRes = new AnnotationPageImpl();
            ArrayList<Annotation> resList = new ArrayList<Annotation>();
            for (Annotation ann : webAnnoStoredAnnoAnnoMap.keySet()) {
                resList.add((Annotation)webAnnoStoredAnnoAnnoMap.get(ann));
            }
            apRes.setAnnotations(resList);
            apRes.setTotalInCollection((long)resList.size());
            apRes.setTotalInPage((long)resList.size());
            String jsonLd = new AnnotationPageSerializer((AnnotationPage)apRes, this.getConfiguration().getAnnotationBaseUrl()).serialize(SearchProfiles.STANDARD);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(3);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"POST");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.CREATED);
            return response;
        }
        catch (AnnotationInstantiationException e) {
            throw new HttpException("The submitted annotation body is invalid!", "error.annotation_invalid_body", null, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected Agent buildAgent(String id, AgentTypes type) {
        Agent agent = AgentObjectFactory.getInstance().createObjectInstance((Enum)type);
        agent.setHttpUrl(id);
        return agent;
    }

    protected ResponseEntity<String> getAnnotationById(long identifier, String profileStr, String language) throws HttpException {
        try {
            Annotation annotation = this.getAnnotationService().getAnnotationById(identifier, null, true);
            SearchProfiles searchProfile = SearchProfiles.getByStr((String)profileStr);
            this.getAnnotationService().dereferenceSemanticTags(annotation, searchProfile, language);
            AnnotationLdSerializer annotationLd = new AnnotationLdSerializer(annotation, this.getConfiguration().getAnnotationBaseUrl());
            String jsonLd = annotationLd.toString(4);
            String eTag = this.generateETag(annotation.getGenerated(), "jsonld", this.buildInfo.getVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"ETag", (Object)eTag);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"GET,PUT,DELETE,OPTIONS,HEAD");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected ResponseEntity<String> getModerationReportSummary(String wsKey, long identifier) throws HttpException {
        try {
            ModerationRecord moderationRecord = this.getAnnotationService().findModerationRecordById(identifier);
            if (moderationRecord == null) {
                moderationRecord = this.buildNewModerationRecord(identifier, null);
            }
            Gson gsonObj = new Gson();
            String jsonString = gsonObj.toJson((Object)moderationRecord.getSummary());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"ETag", (Object)Integer.toString(this.hashCode()));
            headers.add((Object)"Allow", (Object)"GET");
            ResponseEntity response = new ResponseEntity((Object)jsonString, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private Annotation verifyOwnerOrAdmin(long identifier, Authentication authentication, boolean enabled) throws HttpException {
        String userId = AnnotationIdHelper.buildCreatorUri((String)this.getConfiguration().getAnnoUserDataEndpoint(), (String)((String)authentication.getPrincipal()));
        Annotation annotation = this.getAnnotationService().getAnnotationById(identifier, userId, enabled);
        boolean isOwner = annotation.getCreator().getHttpUrl().equals(userId);
        if (isOwner || AnnotationAuthorizationUtils.hasRole((Authentication)authentication, (String)UserRoles.admin.getName())) {
            return annotation;
        }
        throw new ApplicationAuthenticationException("error.operation_not_authorized", "error.operation_not_authorized", new String[]{"Only the creators of the annotation or admins are authorized to perform this operation."}, HttpStatus.FORBIDDEN);
    }

    protected ResponseEntity<String> updateAnnotation(long identifier, String annotation, Authentication authentication, HttpServletRequest request) throws HttpException {
        try {
            Annotation storedAnnotation = this.verifyOwnerOrAdmin(identifier, authentication, true);
            Annotation updateWebAnnotation = this.getAnnotationService().parseAnnotationLd(null, annotation);
            String eTagOrigin = this.generateETag(storedAnnotation.getGenerated(), "jsonld", this.buildInfo.getVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            this.getAnnotationService().validateWebAnnotation(updateWebAnnotation, authentication);
            Annotation updatedAnnotation = this.getAnnotationService().updateAnnotation((PersistentAnnotation)storedAnnotation, updateWebAnnotation);
            String eTag = this.generateETag(updatedAnnotation.getGenerated(), "jsonld", this.buildInfo.getVersion());
            AnnotationLdSerializer annotationLd = new AnnotationLdSerializer(updatedAnnotation, this.getConfiguration().getAnnotationBaseUrl());
            String jsonLd = annotationLd.toString(4);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"ETag", (Object)eTag);
            headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            headers.add((Object)"Allow", (Object)"GET,PUT,DELETE");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (JsonParseException e) {
            throw new RequestBodyValidationException(annotation, "error.annotation_cant_parse_body", (Throwable)e);
        }
        catch (AnnotationValidationException e) {
            throw new RequestBodyValidationException(annotation, "error.annotation_cant_parse_body", (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (AnnotationInstantiationException e) {
            throw new HttpException("The submitted annotation body is invalid!", "error.annotation_validation", null, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        catch (AnnotationServiceException e) {
            throw SearchServiceUtils.convertSearchException((String)annotation, (AnnotationServiceException)e);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected ResponseEntity<String> deleteAnnotation(long identifier, Authentication authentication, HttpServletRequest request) throws HttpException {
        try {
            Annotation storedAnno = this.verifyOwnerOrAdmin(identifier, authentication, true);
            String eTagOrigin = this.generateETag(storedAnno.getGenerated(), "jsonld", this.buildInfo.getVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            this.getAnnotationService().disableAnnotation(storedAnno);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            ResponseEntity response = new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NO_CONTENT);
            return response;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected ResponseEntity<String> enableAnnotation(long identifier, Authentication authentication, HttpServletRequest request) throws HttpException {
        try {
            Annotation storedAnno = this.verifyOwnerOrAdmin(identifier, authentication, false);
            String eTagOrigin = this.generateETag(storedAnno.getGenerated(), "jsonld", this.buildInfo.getVersion());
            this.checkIfMatchHeader(eTagOrigin, request);
            this.getAnnotationService().enableAnnotation(storedAnno.getIdentifier());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            AnnotationLdSerializer annotationLd = new AnnotationLdSerializer(storedAnno, this.getConfiguration().getAnnotationBaseUrl());
            String jsonLd = annotationLd.toString(4);
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected ResponseEntity<String> storeAnnotationReport(long identifier, Authentication authentication) throws HttpException {
        try {
            String userId = authentication.getPrincipal().toString();
            if (!this.getAnnotationService().existsInDb(identifier)) {
                throw new ParamValidationI18NException("An annotation with the given identifier already exists in database! Overwrite not allowed in this method!", "error.annotation_validation", new String[]{"identifier", String.valueOf(identifier)});
            }
            Date reportDate = new Date();
            Vote vote = this.buildVote(this.buildAgent(userId, AgentTypes.PERSON), reportDate);
            ModerationRecord moderationRecord = this.getAnnotationService().findModerationRecordById(identifier);
            if (moderationRecord == null) {
                moderationRecord = this.buildNewModerationRecord(identifier, reportDate);
            } else {
                this.validateVote(moderationRecord, vote);
            }
            moderationRecord.addReport(vote);
            moderationRecord.computeSummary();
            moderationRecord.setLastUpdated(reportDate);
            ModerationRecord storedModeration = this.getAnnotationService().storeModerationRecord(moderationRecord);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Vary", (Object)"Accept");
            headers.add((Object)"ETag", (Object)Long.toString(storedModeration.getLastUpdated().hashCode()));
            headers.add((Object)"Vary", (Object)"Accept");
            ResponseEntity response = new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.CREATED);
            return response;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private void validateVote(ModerationRecord moderationRecord, Vote vote) throws OperationAuthorizationException {
        for (Vote existingVote : moderationRecord.getReportList()) {
            if (!vote.getUserId().equals(existingVote.getUserId())) continue;
            throw new OperationAuthorizationException("A report from the same users exists in database!", "error.operation_not_authorized", new String[]{vote.getUserId()});
        }
    }

    protected ModerationRecord buildNewModerationRecord(long annoIdentifier, Date reportDate) {
        BaseModerationRecord moderationRecord = new BaseModerationRecord();
        moderationRecord.setIdentifier(annoIdentifier);
        moderationRecord.setCreated(reportDate);
        moderationRecord.setLastUpdated(reportDate);
        BaseSummary summary = new BaseSummary();
        moderationRecord.setSummary((Summary)summary);
        return moderationRecord;
    }

    protected Vote buildVote(Agent user, Date reportDate) {
        BaseVote vote = new BaseVote();
        vote.setCreated(reportDate);
        vote.setUserId(user.getHttpUrl());
        return vote;
    }
}

