/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.jsonld;

import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.statistics.model.AnnotationMetric;
import eu.europeana.annotation.statistics.serializer.AnnotationStatisticsSerializer;
import eu.europeana.annotation.statistics.service.AnnotationStatisticsService;
import eu.europeana.annotation.web.service.SearchServiceUtils;
import eu.europeana.annotation.web.service.controller.jsonld.BaseJsonldRest;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Annotation Statistics"}, description=" ")
public class AnnotationStatisticsRest
extends BaseJsonldRest {
    @Resource(name="annotationStatisticsService")
    AnnotationStatisticsService annotationStatisticsService;

    @GetMapping(value={"/annotation/stats"}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="Generate annotations statisticss", nickname="generateAnnotationStatistics", response=Void.class)
    public ResponseEntity<String> generateAnnotationStatistics(@RequestParam(value="wskey", required=true) String wsKey, HttpServletRequest request) throws HttpException {
        this.verifyReadAccess(request);
        return this.getAnnotationStatistics(request);
    }

    private ResponseEntity<String> getAnnotationStatistics(HttpServletRequest request) throws HttpException {
        AnnotationMetric annoMetric = new AnnotationMetric();
        annoMetric.setCreated(new Date());
        try {
            this.annotationStatisticsService.getAnnotationsStatistics(annoMetric);
        }
        catch (AnnotationServiceException e) {
            throw SearchServiceUtils.convertSearchException((String)"verify statistics computation queries", (AnnotationServiceException)e);
        }
        String json = this.serializeMetricView(annoMetric);
        return this.buildUsageStatsResponse(json);
    }

    private ResponseEntity<String> buildUsageStatsResponse(String json) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Allow", (Object)"GET");
        return new ResponseEntity((Object)json, (MultiValueMap)headers, HttpStatus.OK);
    }

    private String serializeMetricView(AnnotationMetric annoMetric) throws HttpException {
        AnnotationStatisticsSerializer serializer = new AnnotationStatisticsSerializer();
        try {
            return serializer.serialize(annoMetric);
        }
        catch (IOException e) {
            throw new InternalServerException((Throwable)e);
        }
    }
}

