/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.admin;

import eu.europeana.annotation.definitions.exception.WhitelistValidationException;
import eu.europeana.annotation.definitions.model.whitelist.WhitelistEntry;
import eu.europeana.annotation.utils.parse.WhiteListParser;
import eu.europeana.annotation.web.model.WhitelistOperationResponse;
import eu.europeana.annotation.web.model.WhitelsitSearchResults;
import eu.europeana.annotation.web.service.WhitelistService;
import eu.europeana.annotation.web.service.controller.BaseRest;
import eu.europeana.annotation.web.service.controller.WebUtils;
import eu.europeana.api.commons.exception.ApiKeyExtractionException;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import org.apache.logging.log4j.LogManager;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Whitelist JSON Rest Service"}, description=" ", hidden=true)
@RequestMapping(value={"/whitelist"})
public class WhitelistRest
extends BaseRest {
    @Resource(name="whitelistService")
    private WhitelistService whitelistService;

    public WhitelistService getWhitelistService() {
        return this.whitelistService;
    }

    public void setWhitelistService(WhitelistService whitelistService) {
        this.whitelistService = whitelistService;
    }

    @RequestMapping(value={"/component"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    @ApiOperation(value="Retrieve component name", nickname="getComponentName", response=Void.class)
    public String getComponentName() {
        return "whitelist";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Retrieve whitelist entry for given URL", nickname="getWhitelistEntry", response=Void.class)
    public ResponseEntity<String> getWhitelistEntry(@RequestParam(value="url", required=true) String url, HttpServletRequest request) throws ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("whitelist_retrieve", request);
        WhitelistEntry whitelist = this.getWhitelistService().getWhitelistEntryByUrl(url);
        WhitelistOperationResponse response = new WhitelistOperationResponse(null, "/whitelist/search");
        if (whitelist != null) {
            response.success = true;
            response.setWhitelistEntry(this.serializeWhitelist(whitelist));
        } else {
            String errorMessage = WhitelistOperationResponse.ERROR_NO_OBJECT_FOUND;
            response.action = "get: /whitelist/search";
            response.success = false;
            response.error = errorMessage;
        }
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Retrieve the whole whitelist", nickname="getFullWhitelist", response=Void.class)
    public ResponseEntity<String> getFullWhitelist(HttpServletRequest request) throws ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("whitelist_retrieve", request);
        List whitelist = this.getWhitelistService().getWhitelist();
        String action = "get:/whitelist/view";
        WhitelsitSearchResults response = this.buildSearchWhitelistResponse(whitelist, null, action);
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Add a new entry to whitelist", nickname="createWhitelistEntry", response=Void.class)
    public ResponseEntity<String> createWhitelistEntry(@RequestBody String whitelist, HttpServletRequest request) throws HttpException, ApiKeyExtractionException, AuthorizationExtractionException {
        this.verifyWriteAccess("whitelist_create", request);
        String action = "post:/whitelist/create";
        WhitelistEntry webWhitelist = WhiteListParser.toWhitelistEntry((String)whitelist);
        WhitelistEntry storedWhitelist = this.getWhitelistService().storeWhitelistEntry(webWhitelist);
        WhitelistOperationResponse response = new WhitelistOperationResponse(null, action);
        response.success = true;
        response.setWhitelistEntry(this.serializeWhitelist(storedWhitelist));
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/load"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="Load the default whitelist entries in DB", nickname="loadDefaultWhitelist", response=Void.class)
    public ResponseEntity<String> loadDefaultWhitelist(HttpServletRequest request) throws WhitelistValidationException, ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("whitelist_create", request);
        List whitelist = this.getWhitelistService().loadWhitelistFromResources();
        String action = "/load";
        WhitelsitSearchResults response = this.buildSearchWhitelistResponse(whitelist, null, action);
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr);
    }

    @DELETE
    @RequestMapping(value={"/deleteall"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Delete the whole whitelist", nickname="deleteAllWhitelistEntries", response=Void.class)
    public ResponseEntity<String> deleteAllWhitelistEntries(HttpServletRequest request) throws ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("whitelist_delete", request);
        WhitelistOperationResponse response = new WhitelistOperationResponse(null, "/whitelist/deleteall");
        try {
            int numDeletedWhitelistEntries = this.getWhitelistService().deleteWholeWhitelist();
            response.success = true;
            response.error = "number of deleted whitelist entries: " + Integer.toString(numDeletedWhitelistEntries);
        }
        catch (Exception e) {
            LogManager.getLogger((String)"root").error((Object)e);
            response.success = false;
            response.error = e.getMessage();
        }
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr);
    }

    @DELETE
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Delete an entry from the whitelist", nickname="deleteWhitelistEntry", response=Void.class)
    public ResponseEntity<String> deleteWhitelistEntry(@RequestParam(value="url", required=true) String url, HttpServletRequest request) throws ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("whitelist_delete", request);
        WhitelistOperationResponse response = new WhitelistOperationResponse(null, "delete/whitelist/delete");
        try {
            int numDeletedWhitelistEntries = this.getWhitelistService().deleteWhitelistEntry(url);
            response.success = true;
            response.error = "number of deleted whitelist entries: " + Integer.toString(numDeletedWhitelistEntries);
        }
        catch (Exception e) {
            LogManager.getLogger((String)"root").error((Object)e);
            response.success = false;
            response.error = e.getMessage();
        }
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr);
    }
}

