/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller.admin;

import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.utils.parse.BaseJsonParser;
import eu.europeana.annotation.web.exception.IndexingJobLockedException;
import eu.europeana.annotation.web.exception.authorization.OperationAuthorizationException;
import eu.europeana.annotation.web.exception.authorization.UserAuthorizationException;
import eu.europeana.annotation.web.exception.request.RequestBodyValidationException;
import eu.europeana.annotation.web.model.AnnotationOperationResponse;
import eu.europeana.annotation.web.model.BatchProcessingStatus;
import eu.europeana.annotation.web.service.AdminService;
import eu.europeana.annotation.web.service.controller.BaseRest;
import eu.europeana.annotation.web.service.controller.WebUtils;
import eu.europeana.api.commons.definitions.exception.ApiWriteLockException;
import eu.europeana.api.commons.nosql.entity.ApiWriteLock;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.exception.InternalServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Web Annotation Admin"}, description=" ", hidden=true)
public class ManagementRest
extends BaseRest {
    Logger logger = LogManager.getLogger(this.getClass());
    @Resource(name="adminService")
    private AdminService adminService;
    @Resource(name="annotation_db_apilockService")
    private ApiWriteLockService apiWriteLockService;

    public AdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public ApiWriteLockService getApiWriteLockService() {
        return this.apiWriteLockService;
    }

    public void setPersistentIndexingJobService(ApiWriteLockService apiWriteLockService) {
        this.apiWriteLockService = apiWriteLockService;
    }

    @RequestMapping(value={"/admin/annotation/delete"}, method={RequestMethod.DELETE}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Delete Annotation for good", nickname="deleteAnnotationById", response=Void.class)
    public ResponseEntity<String> deleteAnnotationById(@RequestParam(value="identifier", required=true) long identifier, HttpServletRequest request) throws HttpException {
        if (this.getConfiguration().isAuthEnabled()) {
            this.verifyWriteAccess("admin_all", request);
        }
        this.deleteAnnotationForGood(identifier);
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/annotation/delete");
        response.success = true;
        String jsonStr = WebUtils.toJson((Object)response);
        this.logger.info("Delete Annotation for good result: " + jsonStr);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/admin/annotation/deleteset"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Delete a set of Annotations for good", nickname="deleteAnnotationSet", notes="identifiers parameter needs to be provided as a an (json) array of annotation ids. e.g. [{\"anno_id\":<numeric_id>}, ..]", response=Void.class)
    public ResponseEntity<String> deleteAnnotationSet(@RequestBody String identifiers, HttpServletRequest request) throws HttpException {
        this.verifyWriteAccess("admin_all", request);
        List identifierList = this.parseIdentifiers(identifiers);
        BatchProcessingStatus status = this.getAdminService().deleteAnnotationSet(identifierList);
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/annotation/deleteset");
        response.setStatus("Success count: " + status.getSuccessCount() + ". Failure count: " + status.getFailureCount());
        response.success = true;
        String jsonStr = WebUtils.toJson((Object)response);
        this.logger.info("Delete a set of Annotations for good result: " + jsonStr);
        return this.buildResponse(jsonStr);
    }

    private List<Long> parseIdentifiers(String identifiers) throws RequestBodyValidationException {
        List identifiersList;
        try {
            identifiersList = BaseJsonParser.extractAnnotationIds((String)identifiers);
        }
        catch (IOException e) {
            throw new RequestBodyValidationException("Cannot parse request body! Body must be in form of [{\"anno_id\":<numeric_id>}, ..]", null, (String[])null);
        }
        return identifiersList;
    }

    protected void deleteAnnotationForGood(long identifier) throws InternalServerException, UserAuthorizationException, ApplicationAuthenticationException, OperationAuthorizationException {
        try {
            this.getAdminService().deleteAnnotation(identifier);
        }
        catch (AnnotationServiceException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @RequestMapping(value={"/admin/annotation/reindex"}, method={RequestMethod.PUT}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Reindex by annotation id. Authorization required.", nickname="reindexAnnotationByAnnotationId", response=Void.class)
    public ResponseEntity<String> reindexAnnotationByAnnotationId(@RequestParam(value="identifier", required=true, defaultValue="1") long identifier, HttpServletRequest request) throws UserAuthorizationException, HttpException {
        this.verifyWriteAccess("admin_reindex", request);
        this.getAdminService().reindexAnnotationById(identifier, new Date());
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/reindex");
        String jsonStr = WebUtils.toJson((Object)response);
        this.logger.info("Reindex by annotation id result: " + jsonStr);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/admin/annotation/reindexselection"}, method={RequestMethod.PUT}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Reindex a set of annotations defined by selection criteria. Authorization required.", notes="Valid date format is: dd-MM-yyyy", nickname="reindexAnnotationSelection", response=Void.class)
    public ResponseEntity<String> reindexAnnotationSelection(@RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="startTimestamp", required=false) String startTimestamp, @RequestParam(value="endTimestamp", required=false) String endTimestamp, HttpServletRequest request) throws UserAuthorizationException, ApiWriteLockException, IndexingJobLockedException, HttpException {
        this.verifyWriteAccess("admin_reindex", request);
        BatchProcessingStatus status = this.getAdminService().reindexAnnotationSelection(startDate, endDate, startTimestamp, endTimestamp, "reindexAnnotationSelection");
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/reindexselection");
        response.setStatus(status.toString());
        String jsonStr = WebUtils.toJson((Object)response);
        this.logger.info("Reindex a set of annotations defined by selection criteria result: " + jsonStr);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/admin/annotation/reindexset"}, method={RequestMethod.PUT}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Reindex a set of annotations. Authorization required.", nickname="reindexAnnotationByAnnotationId", notes="identifiers parameter needs to be provided as a an (json) array of annotation ids. e.g. [{\"anno_id\":<numeric_id>}, ..]", response=Void.class)
    public ResponseEntity<String> reindexAnnotationSet(@RequestBody String identifiers, HttpServletRequest request) throws UserAuthorizationException, HttpException {
        BatchProcessingStatus status;
        this.verifyWriteAccess("admin_reindex", request);
        List identifierList = this.parseIdentifiers(identifiers);
        try {
            status = this.getAdminService().reindexAnnotationSet(identifierList, "/admin/annotation/reindexset");
        }
        catch (ApiWriteLockException e) {
            throw new InternalServerException("Cannot reindex annotation selection", (Throwable)e);
        }
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/annotation/reindexset");
        response.setStatus("Success count: " + status.getSuccessCount() + ". Failure count: " + status.getFailureCount());
        response.success = status.getSuccessCount() > 0;
        String jsonStr = WebUtils.toJson((Object)response);
        HttpStatus httpStatus = response.success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR;
        this.logger.info("Reindex a set of annotations result: " + jsonStr + "(HTTP status: " + httpStatus.toString() + ")");
        return this.buildResponse(jsonStr, httpStatus);
    }

    @RequestMapping(value={"/admin/annotation/reindexall"}, method={RequestMethod.PUT}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Reindex all annotations. Authorization required.", nickname="reindexAll", response=Void.class)
    public ResponseEntity<String> reindexAll(HttpServletRequest request) throws UserAuthorizationException, HttpException {
        BatchProcessingStatus status;
        this.verifyWriteAccess("admin_reindex", request);
        try {
            status = this.getAdminService().reindexAll();
        }
        catch (ApiWriteLockException e) {
            throw new InternalServerException("Cannot reindex annotation selection", (Throwable)e);
        }
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/annotation/reindexall");
        response.setStatus("Success count: " + status.getSuccessCount() + ". Failure count: " + status.getFailureCount());
        response.success = true;
        String jsonStr = WebUtils.toJson((Object)response);
        this.logger.info("Reindex all annotations result: " + jsonStr);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/admin/annotation/reindexoutdated"}, method={RequestMethod.PUT}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Index new and reindex outdated annotations. Authorization required.", nickname="reindexOutdated", response=Void.class)
    public ResponseEntity<String> reindexOutdated(HttpServletRequest request) throws UserAuthorizationException, HttpException {
        BatchProcessingStatus status;
        this.verifyWriteAccess("admin_reindex", request);
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/annotation/reindexoutdated");
        try {
            status = this.getAdminService().reindexOutdated();
        }
        catch (ApiWriteLockException e) {
            throw new InternalServerException("Cannot reindex annotation selection", (Throwable)e);
        }
        String successMsg = "Outdated annotations reindexed. " + status.toString();
        response.setStatus(successMsg);
        response.success = true;
        HttpStatus httpStatus = HttpStatus.OK;
        this.logger.info(successMsg);
        String jsonStr = WebUtils.toJson((Object)response);
        return this.buildResponse(jsonStr, httpStatus);
    }

    @RequestMapping(value={"/admin/annotation/updateRecordId"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Update record identifiers with new ones. Authorization required.", nickname="updateRecordId", response=Void.class)
    public ResponseEntity<String> updateRecordId(@RequestParam(value="old", required=true) String oldId, @RequestParam(value="new", required=true) String newId, HttpServletRequest request) throws HttpException {
        this.verifyWriteAccess("admin_all", request);
        if (oldId.isEmpty() || newId.isEmpty()) {
            throw new HttpException("Both newId and oldId parameters must be provided!", null, null, HttpStatus.BAD_REQUEST);
        }
        BatchProcessingStatus status = this.getAdminService().updateRecordId(oldId, newId);
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/annotation/updateRecordId");
        response.setStatus("Updated record IDs. " + status.toString());
        response.success = true;
        String jsonStr = WebUtils.toJson((Object)response);
        this.logger.info("Update record ID operation result. \n Old ID: " + oldId + "\nnewId : " + newId + "\nResult: " + jsonStr);
        return this.buildResponse(jsonStr);
    }

    @RequestMapping(value={"/admin/lock"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Lock write operations. Authorization required.", nickname="lockWriteOperations", response=Void.class)
    public ResponseEntity<String> lockWriteOperations(HttpServletRequest request) throws ApiWriteLockException, ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("admin_all", request);
        ApiWriteLock activeLock = this.getApiWriteLockService().getLastActiveLock("lockWriteOperations");
        boolean isLocked = false;
        if (activeLock == null) {
            activeLock = this.getApiWriteLockService().lock("lockWriteOperations");
        }
        isLocked = this.isLocked(activeLock);
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/lock");
        response.setStatus(isLocked ? "Server is now locked for changes" : "Unable to set lock");
        response.success = isLocked;
        String jsonStr = WebUtils.toJson((Object)response);
        HttpStatus httpStatus = response.success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR;
        this.logger.info("Lock write operations result: " + jsonStr + "(HTTP status: " + httpStatus.toString() + ")");
        return this.buildResponse(jsonStr, httpStatus);
    }

    private boolean isLocked(ApiWriteLock activeLock) {
        return activeLock != null && activeLock.getStarted() != null && activeLock.getEnded() == null;
    }

    @RequestMapping(value={"/admin/lock"}, method={RequestMethod.DELETE}, produces={"application/json;charset=utf-8", "application/ld+json;charset=utf-8"})
    @ApiOperation(value="Unlock write operations", nickname="unlockWriteOperations", response=Void.class)
    public ResponseEntity<String> unlockWriteOperations(HttpServletRequest request) throws ApiWriteLockException, ApplicationAuthenticationException, InternalServerException {
        this.verifyWriteAccess("write_unlock", request);
        AnnotationOperationResponse response = new AnnotationOperationResponse("admin", "/admin/unlock");
        ApiWriteLock activeLock = this.getApiWriteLockService().getLastActiveLock("lockWriteOperations");
        if (activeLock != null && activeLock.getName().equals("lockWriteOperations") && activeLock.getEnded() == null) {
            this.getApiWriteLockService().unlock(activeLock);
            ApiWriteLock lock = this.getApiWriteLockService().getLastActiveLock("lockWriteOperations");
            if (lock == null) {
                response.setStatus("Server is now unlocked for changes");
                response.success = true;
            } else {
                response.setStatus("Unlocking write operations failed");
                response.success = false;
            }
        } else {
            response.setStatus("No write lock in effect (remains unlocked)");
            response.success = true;
        }
        String jsonStr = WebUtils.toJson((Object)response);
        HttpStatus httpStatus = response.success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR;
        this.logger.info("Unlock write operations result: " + jsonStr + "(HTTP status: " + httpStatus.toString() + ")");
        return this.buildResponse(jsonStr, httpStatus);
    }
}

