/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller;

import eu.europeana.annotation.config.AnnotationConfiguration;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.impl.AbstractAnnotation;
import eu.europeana.annotation.definitions.model.utils.AnnotationBuilder;
import eu.europeana.annotation.definitions.model.utils.TypeUtils;
import eu.europeana.annotation.definitions.model.whitelist.WhitelistEntry;
import eu.europeana.annotation.mongo.model.internal.PersistentWhitelistEntry;
import eu.europeana.annotation.mongo.service.PersistentAnnotationService;
import eu.europeana.annotation.web.model.AnnotationSearchResults;
import eu.europeana.annotation.web.model.WhitelsitSearchResults;
import eu.europeana.annotation.web.service.AnnotationSearchService;
import eu.europeana.annotation.web.service.AnnotationService;
import eu.europeana.annotation.web.service.authorization.AnnotationAuthorizationUtils;
import eu.europeana.annotation.web.service.authorization.AuthorizationService;
import eu.europeana.annotation.web.service.authorization.AuthorizationServiceImpl;
import eu.europeana.annotation.web.service.impl.AnnotationServiceImpl;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.oauth2.model.ApiCredentials;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaApiCredentials;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaAuthenticationToken;
import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.info.BuildProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class BaseRest
extends BaseRestController {
    @Resource
    AnnotationConfiguration configuration;
    @Autowired
    @Qualifier(value="annotationService")
    private AnnotationServiceImpl annotationService;
    @Resource(name="annotation_authorizationService")
    AuthorizationService authorizationService;
    @Resource(name="annotationSearchService")
    AnnotationSearchService annotationSearchService;
    @Resource(name="annotation_db_annotationService")
    protected PersistentAnnotationService mongoPersistance;
    @Resource
    protected BuildProperties buildInfo;
    Logger logger = LogManager.getLogger(this.getClass());
    TypeUtils typeUtils = new TypeUtils();

    public AnnotationSearchService getAnnotationSearchService() {
        return this.annotationSearchService;
    }

    public void setAnnotationSearchService(AnnotationSearchService annotationSearchService) {
        this.annotationSearchService = annotationSearchService;
    }

    protected TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    protected AnnotationConfiguration getConfiguration() {
        return this.configuration;
    }

    protected AnnotationService getAnnotationService() {
        return this.annotationService;
    }

    public void setConfiguration(AnnotationConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toResourceId(String collection, String object) {
        return "/" + collection + "/" + object;
    }

    public AnnotationSearchResults<AbstractAnnotation> buildSearchResponse(List<? extends Annotation> annotations, String apiKey, String action) {
        AnnotationSearchResults response = new AnnotationSearchResults(apiKey, action);
        response.items = new ArrayList(annotations.size());
        for (Annotation annotation : annotations) {
            AbstractAnnotation webAnnotation = AnnotationBuilder.copyIntoWebAnnotation((Annotation)annotation);
            response.items.add(webAnnotation);
        }
        response.itemsCount = response.items.size();
        response.totalResults = annotations.size();
        return response;
    }

    public WhitelistEntry serializeWhitelist(WhitelistEntry entry) {
        ((PersistentWhitelistEntry)entry).setId(null);
        return entry;
    }

    public WhitelsitSearchResults<WhitelistEntry> buildSearchWhitelistResponse(List<? extends WhitelistEntry> entries, String apiKey, String action) {
        WhitelsitSearchResults response = new WhitelsitSearchResults(apiKey, action);
        ArrayList<WhitelistEntry> webWhitelist = new ArrayList<WhitelistEntry>();
        for (WhitelistEntry whitelistEntry : entries) {
            whitelistEntry.setCreationDate(null);
            whitelistEntry.setLastUpdate(null);
            whitelistEntry.setEnableFrom(null);
            whitelistEntry.setDisableTo(null);
            ((PersistentWhitelistEntry)whitelistEntry).setId(null);
            webWhitelist.add(whitelistEntry);
        }
        response.items = webWhitelist;
        response.itemsCount = response.items.size();
        response.totalResults = entries.size();
        return response;
    }

    public AnnotationSearchResults<AbstractAnnotation> buildSearchErrorResponse(String apiKey, String action, Throwable th) {
        AnnotationSearchResults response = new AnnotationSearchResults(apiKey, action);
        response.success = false;
        response.error = th.getMessage();
        return response;
    }

    protected ResponseEntity<String> buildResponse(String jsonStr) {
        HttpStatus httpStatus = HttpStatus.OK;
        ResponseEntity response = this.buildResponse(jsonStr, httpStatus);
        return response;
    }

    protected ResponseEntity<String> buildResponse(String jsonStr, HttpStatus httpStatus) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
        headers.add((Object)"Vary", (Object)"Accept");
        headers.add((Object)"ETag", (Object)Integer.toString(this.hashCode()));
        headers.add((Object)"Allow", (Object)"GET");
        ResponseEntity response = new ResponseEntity((Object)jsonStr, (MultiValueMap)headers, httpStatus);
        return response;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public String decodeBase64(String base64Str) throws ApplicationAuthenticationException {
        String res = null;
        try {
            byte[] decodedBase64Str = Base64.decodeBase64((byte[])base64Str.getBytes(StandardCharsets.UTF_8));
            res = new String(decodedBase64Str);
        }
        catch (Exception e) {
            throw new ApplicationAuthenticationException("error.annotation_base64_encoding_fail", "error.annotation_base64_encoding_fail", null);
        }
        return res;
    }

    public String getUserToken(String paramUserToken, HttpServletRequest request) throws ApplicationAuthenticationException {
        int USER_TOKEN_TYPE_POS = 0;
        int BASE64_ENCODED_STRING_POS = 1;
        String userToken = null;
        String userTokenHeader = request.getHeader("Authorization");
        if (userTokenHeader != null) {
            String[] headerElems = userTokenHeader.split(" ");
            if (headerElems.length < 2) {
                throw new ApplicationAuthenticationException("error.annotation_invalid_format", "error.annotation_invalid_format", null);
            }
            String userTokenType = headerElems[USER_TOKEN_TYPE_POS];
            if (!"Bearer".equals(userTokenType)) {
                throw new ApplicationAuthenticationException("error.annotation_unsupported_token_type", "error.annotation_unsupported_token_type", new String[]{userTokenType});
            }
            String encodedUserToken = headerElems[BASE64_ENCODED_STRING_POS];
            userToken = this.decodeBase64(encodedUserToken);
            this.logger.debug("Decoded user token: {}", (Object)userToken);
        } else {
            userToken = paramUserToken;
        }
        return userToken;
    }

    public Authentication verifyWriteAccess(String operation, HttpServletRequest request) throws ApplicationAuthenticationException {
        this.getAuthorizationService().checkWriteLockInEffect(operation);
        Authentication auth = null;
        auth = this.getConfiguration().isAuthEnabled() ? super.verifyWriteAccess(operation, request) : (StringUtils.isBlank((CharSequence)request.getHeader("Authorization")) ? this.createAnnonymousUser() : this.authorizeByPlainTextToken(operation, request));
        return auth;
    }

    private Authentication createAnnonymousUser() {
        EuropeanaAuthenticationToken auth = new EuropeanaAuthenticationToken(null, "annotations", "annonymous-user", (ApiCredentials)new EuropeanaApiCredentials("anonymous", "unknown-client"));
        return auth;
    }

    public Authentication verifyReadAccess(HttpServletRequest request) throws ApplicationAuthenticationException {
        if (this.getConfiguration().isAuthEnabled()) {
            return this.getAuthorizationService().authorizeReadAccess(request);
        }
        if (StringUtils.isBlank((CharSequence)request.getHeader("Authorization"))) {
            return this.createAnnonymousUser();
        }
        return this.authorizeByPlainTextToken("retrieve", request);
    }

    private Authentication authorizeByPlainTextToken(String operation, HttpServletRequest request) throws ApplicationAuthenticationException {
        Authentication auth = null;
        try {
            auth = AnnotationAuthorizationUtils.createAuthentication((String)request.getHeader("Authorization"), (String)this.configuration.getAuthorizationApiName());
            auth = ((AuthorizationServiceImpl)this.getAuthorizationService()).checkPermissions(auth, operation);
        }
        catch (AuthorizationExtractionException e) {
            throw new ApplicationAuthenticationException("Authentication error: " + e.getMessage(), "error.operation_not_authorized", new String[]{operation}, HttpStatus.UNAUTHORIZED, (Throwable)e);
        }
        return auth;
    }
}

