/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.controller;

import eu.europeana.annotation.web.exception.response.BatchUploadException;
import eu.europeana.annotation.web.model.AnnotationOperationResponse;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ApiResponseBuilder {
    public AnnotationOperationResponse buildErrorResponse(String errorMessage, String action, String apiKey) {
        AnnotationOperationResponse response = new AnnotationOperationResponse(apiKey, action);
        response.success = false;
        response.error = errorMessage;
        return response;
    }

    protected AnnotationOperationResponse getValidationReport(String apiKey, String action, String errorMessage, Throwable th, boolean includeErrorStack) {
        AnnotationOperationResponse response = new AnnotationOperationResponse(apiKey, action);
        String blank = " ";
        StringBuilder messageBuilder = new StringBuilder();
        if (errorMessage != null) {
            messageBuilder.append(" ").append(errorMessage).append(". ");
        }
        if (th != null) {
            if (errorMessage != null) {
                messageBuilder.append("Caused by: ");
            }
            messageBuilder.append(th.getMessage());
        }
        if (th != null && th.getCause() != null && th != th.getCause()) {
            messageBuilder.append(" ").append(th.getCause().getMessage());
        }
        response = this.buildErrorResponse(messageBuilder.toString(), response.action, response.apikey);
        if (includeErrorStack && th != null) {
            response.setStackTrace(this.getStackTraceAsString(th));
        }
        if (th instanceof BatchUploadException) {
            response.setOperationReport(((BatchUploadException)th).getOperationReport());
        }
        return response;
    }

    String getStackTraceAsString(Throwable th) {
        StringWriter out = new StringWriter();
        th.printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    public AnnotationOperationResponse buildResponse(String message, String action, String apiKey) {
        AnnotationOperationResponse response = new AnnotationOperationResponse(apiKey, action);
        response.success = true;
        response.setStatus(message);
        return response;
    }
}

