/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.authorization;

import eu.europeana.annotation.config.AnnotationConfiguration;
import eu.europeana.annotation.web.model.vocabulary.UserRoles;
import eu.europeana.annotation.web.service.authorization.AuthorizationService;
import eu.europeana.api.commons.definitions.vocabulary.Role;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.service.authorization.BaseAuthorizationService;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.security.oauth2.provider.ClientDetailsService;

public class AuthorizationServiceImpl
extends BaseAuthorizationService
implements AuthorizationService {
    @Resource
    AnnotationConfiguration configuration;
    @Resource(name="commons_oauth2_europeanaClientDetailsService")
    ClientDetailsService clientDetailsService;
    @Resource(name="annotation_db_apilockService")
    private ApiWriteLockService apiWriteLockService;
    private final Set<String> maintenanceOperations = Set.of("write_unlock", "admin_reindex");

    protected String getAuthorizationApiName() {
        return this.getConfiguration().getAuthorizationApiName();
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    protected String getSignatureKey() {
        return this.getConfiguration().getJwtTokenSignatureKey();
    }

    protected Role getRoleByName(String name) {
        return UserRoles.getRoleByName((String)name);
    }

    protected String getApiName() {
        return this.getConfiguration().getAuthorizationApiName();
    }

    protected ApiWriteLockService getApiWriteLockService() {
        return this.apiWriteLockService;
    }

    protected Set<String> getMaintenanceOperations() {
        return this.maintenanceOperations;
    }

    public AnnotationConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AnnotationConfiguration configuration) {
        this.configuration = configuration;
    }
}

