/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service.authorization;

import eu.europeana.annotation.web.model.vocabulary.UserRoles;
import eu.europeana.api.commons.definitions.vocabulary.Role;
import eu.europeana.api.commons.exception.AuthorizationExtractionException;
import eu.europeana.api.commons.oauth2.model.ApiCredentials;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaApiCredentials;
import eu.europeana.api.commons.oauth2.model.impl.EuropeanaAuthenticationToken;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnnotationAuthorizationUtils {
    private AnnotationAuthorizationUtils() {
    }

    public static Authentication createAuthentication(String userId, String userName, Role role, String apiName) {
        return AnnotationAuthorizationUtils.createAuthentication((String)userId, (String)userName, (String)role.getName(), (String)apiName);
    }

    private static Authentication createAuthentication(String userId, String userName, String roleName, String apiName) {
        SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority(roleName);
        return new EuropeanaAuthenticationToken(List.of(grantedAuthority), apiName, userId, (ApiCredentials)new EuropeanaApiCredentials(userName, "unknown-client"));
    }

    public static Authentication createAuthentication(String plainTextToken, String apiName) throws AuthorizationExtractionException {
        int SEPARATOR_COUNT = 2;
        if (StringUtils.isBlank((CharSequence)plainTextToken) || StringUtils.countMatches((CharSequence)plainTextToken, (char)':') != 2) {
            throw new AuthorizationExtractionException("invalid plain text token: " + plainTextToken);
        }
        String plainToken = plainTextToken.replace("Bearer", "");
        String[] parts = plainToken.trim().split("\\:");
        return AnnotationAuthorizationUtils.createAuthentication((String)parts[0], (String)parts[1], (Role)UserRoles.valueOf((String)parts[2]), (String)apiName);
    }

    public static boolean hasRole(Authentication authentication, String userRole) {
        Iterator iterator = authentication.getAuthorities().iterator();
        while (iterator.hasNext()) {
            String role = ((GrantedAuthority)iterator.next()).getAuthority();
            if (role == null || !role.equals(userRole)) continue;
            return true;
        }
        return false;
    }
}

