/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.service;

import eu.europeana.annotation.definitions.exception.AnnotationDereferenciationException;
import eu.europeana.annotation.definitions.exception.AnnotationValidationException;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.StatusLog;
import eu.europeana.annotation.definitions.model.moderation.ModerationRecord;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.vocabulary.MotivationTypes;
import eu.europeana.annotation.mongo.exception.BulkOperationException;
import eu.europeana.annotation.mongo.exception.ModerationMongoException;
import eu.europeana.annotation.mongo.model.internal.PersistentAnnotation;
import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.solr.exceptions.StatusLogServiceException;
import eu.europeana.annotation.web.exception.authorization.UserAuthorizationException;
import eu.europeana.annotation.web.exception.request.ParamValidationI18NException;
import eu.europeana.annotation.web.exception.request.PropertyValidationException;
import eu.europeana.annotation.web.exception.request.RequestBodyValidationException;
import eu.europeana.annotation.web.exception.response.AnnotationNotFoundException;
import eu.europeana.annotation.web.exception.response.ModerationNotFoundException;
import eu.europeana.annotation.web.model.BatchReportable;
import eu.europeana.annotation.web.model.BatchUploadStatus;
import eu.europeana.annotation.web.service.AnnotationDefaults;
import eu.europeana.api.commons.web.exception.HttpException;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.stanbol.commons.exception.JsonParseException;
import org.springframework.security.core.Authentication;

public interface AnnotationService {
    public List<? extends Annotation> getAnnotationList(List<Long> var1);

    public List<? extends Annotation> getAnnotationListByTarget(String var1);

    public List<? extends Annotation> getAnnotationListByResourceId(String var1);

    public Annotation parseAnnotationLd(MotivationTypes var1, String var2) throws JsonParseException, HttpException;

    public Annotation storeAnnotation(Annotation var1);

    public Annotation storeAnnotation(Annotation var1, boolean var2);

    public Annotation updateAnnotation(PersistentAnnotation var1, Annotation var2) throws AnnotationServiceException, HttpException;

    public Annotation disableAnnotation(long var1);

    public Annotation enableAnnotation(long var1) throws AnnotationServiceException;

    public Annotation disableAnnotation(Annotation var1);

    public Annotation getAnnotationById(long var1, String var3, boolean var4) throws AnnotationNotFoundException, UserAuthorizationException;

    public List<? extends StatusLog> searchStatusLogs(String var1, String var2, String var3) throws StatusLogServiceException;

    public boolean existsInDb(long var1);

    public boolean existsModerationInDb(long var1) throws ModerationMongoException;

    public Annotation updateAnnotationStatus(Annotation var1);

    public void logAnnotationStatusUpdate(String var1, Annotation var2);

    public void validateWebAnnotation(Annotation var1, Authentication var2) throws ParamValidationI18NException, RequestBodyValidationException, PropertyValidationException;

    public void validateWebAnnotations(List<? extends Annotation> var1, BatchReportable var2, Authentication var3) throws ParamValidationI18NException;

    public void reportNonExisting(List<? extends Annotation> var1, BatchReportable var2, List<Long> var3);

    public ModerationRecord storeModerationRecord(ModerationRecord var1);

    public ModerationRecord findModerationRecordById(long var1) throws ModerationNotFoundException, ModerationMongoException;

    public List<? extends Annotation> getExisting(List<Long> var1);

    public void updateExistingAnnotations(BatchReportable var1, List<? extends Annotation> var2, List<? extends Annotation> var3, LinkedHashMap<Annotation, Annotation> var4) throws AnnotationValidationException, BulkOperationException, IOException, InterruptedException;

    public void insertNewAnnotations(BatchUploadStatus var1, List<? extends Annotation> var2, AnnotationDefaults var3, LinkedHashMap<Annotation, Annotation> var4) throws AnnotationValidationException, BulkOperationException, IOException, InterruptedException;

    public void dereferenceSemanticTags(Annotation var1, SearchProfiles var2, String var3) throws HttpException, AnnotationDereferenciationException;

    public void dereferenceSemanticTags(List<? extends Annotation> var1, SearchProfiles var2, String var3) throws AnnotationDereferenciationException, HttpException;

    public Set<String> checkDuplicateAnnotations(Annotation var1, boolean var2) throws AnnotationServiceException;

    public List<String> getDeletedAnnotationSet(MotivationTypes var1, Date var2, Date var3, int var4, int var5);

    public List<? extends Annotation> getAllAnnotations();
}

