/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.profiling;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.util.StopWatch;

public class SimpleProfiler {
    Logger logger = LogManager.getLogger(this.getClass());

    public Object profile(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(proceedingJoinPoint.toShortString());
        boolean isExceptionThrown = false;
        try {
            object = proceedingJoinPoint.proceed();
        }
        catch (RuntimeException e) {
            try {
                isExceptionThrown = true;
                throw e;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                StopWatch.TaskInfo taskInfo = stopWatch.getLastTaskInfo();
                String profileMessage = taskInfo.getTaskName() + ":\t" + taskInfo.getTimeMillis() + "ms" + (isExceptionThrown ? " (thrown Exception)" : "");
                this.logger.debug("Profiling {}", (Object)profileMessage);
                throw throwable;
            }
        }
        stopWatch.stop();
        StopWatch.TaskInfo taskInfo = stopWatch.getLastTaskInfo();
        String profileMessage = taskInfo.getTaskName() + ":\t" + taskInfo.getTimeMillis() + "ms" + (isExceptionThrown ? " (thrown Exception)" : "");
        this.logger.debug("Profiling {}", (Object)profileMessage);
        return object;
    }
}

