/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.config;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    List<MediaType> supportedMediaTypes = new ArrayList();
    Map<String, MediaType> mediaTypesMaping = new HashMap();
    private static final MediaType APPLICATION_JSONLD = new MediaType("application", "ld+json");
    private static final String EXTENSION_JSONLD = "jsonld";

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v2/api-docs").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/v2/api-docs/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/annotation/").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST"}).exposedHeaders(new String[]{"Allow", "Vary", "Link", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/annotation/admin/lock").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/whitelist/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "DELETE"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/annotation/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"PUT", "GET", "OPTIONS", "HEAD"}).exposedHeaders(new String[]{"Allow", "Vary", "Link", "ETag", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/annotations/*").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers", "Allow"}).allowCredentials(false).maxAge(600L);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true);
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
        configurer.mediaTypes(this.getMediaTypesMapping());
    }

    private Map<String, MediaType> getMediaTypesMapping() {
        if (this.mediaTypesMaping.isEmpty()) {
            for (MediaType mediaType : this.supportedMediaTypes) {
                if (APPLICATION_JSONLD.equals((Object)mediaType)) {
                    this.mediaTypesMaping.put(EXTENSION_JSONLD, mediaType);
                    continue;
                }
                this.mediaTypesMaping.put(mediaType.getSubtype(), mediaType);
            }
        }
        return this.mediaTypesMaping;
    }

    @Bean
    public HttpMessageConverter<String> getStringHttpMessageConverter() {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
        stringConverter.setWriteAcceptCharset(false);
        stringConverter.setSupportedMediaTypes(this.getSupportedMediaTypes());
        return stringConverter;
    }

    private List<MediaType> getSupportedMediaTypes() {
        if (this.supportedMediaTypes.isEmpty()) {
            this.supportedMediaTypes.add(APPLICATION_JSONLD);
            this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
            this.supportedMediaTypes.add(MediaType.TEXT_PLAIN);
            this.supportedMediaTypes.add(MediaType.TEXT_HTML);
        }
        return this.supportedMediaTypes;
    }
}

