/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.config;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:annotation.properties", "classpath:annotation.user.properties"}, ignoreResourceNotFound=true)
public class SolrConfig {
    private static final Logger logger = LogManager.getLogger(SolrConfig.class);
    @Value(value="${solr.annotation.url}")
    private String solrUrl;
    @Value(value="${solr.annotation.timeout}")
    private int solrTimeout;
    @Value(value="${solr.annotation.zookeeper.url:#{null}}")
    private String solrZookeeperUrl;
    @Value(value="${solr.annotation.collection:#{null}}")
    private String solrCollection;
    private SolrClient solrClient;

    @Bean(value={"annoSolrClient"})
    public SolrClient annoSolrClient() {
        logger.info("Configuring annotation solr client at the url: {}", (Object)this.solrUrl);
        if (this.solrClient != null) {
            return this.solrClient;
        }
        if (StringUtils.isNotBlank((CharSequence)this.solrZookeeperUrl)) {
            this.solrClient = this.initSolrCloudClient();
        } else if (StringUtils.isNotBlank((CharSequence)this.solrUrl)) {
            this.solrClient = this.initSolrClient();
        }
        return this.solrClient;
    }

    private SolrClient initSolrClient() {
        if (this.solrUrl.contains(",")) {
            LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
            return ((LBHttpSolrClient.Builder)builder.withBaseSolrUrls(this.solrUrl.split(",")).withConnectionTimeout(this.solrTimeout)).build();
        }
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
        return ((HttpSolrClient.Builder)builder.withBaseSolrUrl(this.solrUrl).withConnectionTimeout(this.solrTimeout)).build();
    }

    private SolrClient initSolrCloudClient() {
        String[] solrZookeeperUrls = this.solrZookeeperUrl.trim().split(",");
        CloudSolrClient.Builder builder = (CloudSolrClient.Builder)new CloudSolrClient.Builder(Arrays.asList(solrZookeeperUrls), Optional.empty()).withConnectionTimeout(this.solrTimeout);
        CloudSolrClient client = builder.build();
        client.setDefaultCollection(this.solrCollection);
        return client;
    }
}

