/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.config;

import eu.europeana.api.commons.net.socks.SocksProxyConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SocksProxyActivator {
    private static final Logger LOG = LogManager.getLogger(SocksProxyActivator.class);
    private static final String PROP_SOCKS_PROXY_URL = "socks.proxy.url";

    private SocksProxyActivator() {
    }

    public static void activate(String propertiesFileName) {
        String socksProxyUrl;
        Properties props = SocksProxyActivator.loadProperties((String)propertiesFileName);
        if (props.containsKey("socks.proxy.url") && StringUtils.isNotBlank((CharSequence)(socksProxyUrl = props.getProperty("socks.proxy.url")))) {
            try {
                SocksProxyConfig socksConfig = new SocksProxyConfig(socksProxyUrl);
                socksConfig.init();
            }
            catch (URISyntaxException e) {
                LOG.warn("Invalid SOCKS Proxy URL {},  skip socks proxy initialization!", (Object)socksProxyUrl, (Object)e);
            }
        }
    }

    private static Properties loadProperties(String propertiesFileName) {
        Properties props = new Properties();
        if (propertiesFileName.startsWith("/")) {
            SocksProxyActivator.loadPropertiesFromFileSystem((String)propertiesFileName, (Properties)props);
        } else {
            SocksProxyActivator.loadPropertiesFromClasspath((String)propertiesFileName, (Properties)props);
        }
        return props;
    }

    private static void loadPropertiesFromClasspath(String propertiesFileName, Properties props) {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName);){
            if (in == null) {
                LOG.warn("Properties file {} does not exist in the classpath!", (Object)propertiesFileName);
            } else {
                props.load(in);
            }
        }
        catch (IOException e) {
            LOG.warn("Error reading properties classpath {}!", (Object)propertiesFileName, (Object)e);
        }
    }

    private static void loadPropertiesFromFileSystem(String propertiesFileName, Properties props) {
        File propsFile = new File(propertiesFileName);
        if (propsFile.exists()) {
            try (FileInputStream in = new FileInputStream(propsFile);){
                props.load(in);
            }
            catch (IOException e) {
                LOG.warn("Cannot read properties file from system {}!", (Object)propertiesFileName);
            }
        }
    }
}

